/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records;

import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.Feature;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public class SimpleCount
implements Locatable,
Feature {
    private final SimpleInterval interval;
    private final int count;

    public SimpleCount(SimpleInterval interval, int count) {
        this.interval = Utils.nonNull(interval);
        this.count = ParamUtils.isPositiveOrZero(count, "Can't construct SimpleCount with negative count.");
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public int getCount() {
        return this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleCount that = (SimpleCount)o;
        return this.count == that.count && this.interval.equals(that.interval);
    }

    public int hashCode() {
        int result = this.interval.hashCode();
        result = 31 * result + this.count;
        return result;
    }

    public String toString() {
        return "SimpleCount{interval=" + this.interval + ", count=" + this.count + '}';
    }
}

