/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records.annotation;

import java.util.function.Function;
import org.broadinstitute.hellbender.utils.Utils;

public final class AnnotationKey<T> {
    private final String name;
    private final Class<T> clazz;
    private final Function<T, Boolean> validateValue;

    public AnnotationKey(String name, Class<T> clazz, Function<T, Boolean> validateValue) {
        this.name = Utils.nonEmpty(name);
        this.clazz = Utils.nonNull(clazz);
        this.validateValue = Utils.nonNull(validateValue);
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.clazz;
    }

    public T validate(T value) {
        Utils.validateArg((boolean)this.validateValue.apply(value), String.format("Invalid value %s for annotation %s.", value, this.name));
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationKey that = (AnnotationKey)o;
        return this.name.equals(that.name) && this.clazz.equals(that.clazz);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.clazz.hashCode();
        return result;
    }

    public String toString() {
        return "AnnotationKey{name='" + this.name + '\'' + ", class=" + this.clazz + '}';
    }
}

