/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.formats.records.annotation;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.annotation.AnnotationKey;
import org.broadinstitute.hellbender.utils.Utils;

public final class AnnotationMap {
    private final Map<AnnotationKey<?>, Object> annotationMap;

    public AnnotationMap(List<Pair<AnnotationKey<?>, Object>> annotations) {
        Utils.nonEmpty(annotations);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        annotations.forEach(a -> builder.put(a.getKey(), a.getValue()));
        this.annotationMap = builder.build();
    }

    public List<AnnotationKey<?>> getKeys() {
        return new ArrayList(this.annotationMap.keySet());
    }

    public <T> T getValue(AnnotationKey<T> key) {
        Utils.nonNull(key);
        if (!this.annotationMap.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Annotation %s not contained in AnnotationMap.", key.getName()));
        }
        return key.getType().cast(this.annotationMap.get(key));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationMap that = (AnnotationMap)o;
        return this.annotationMap.equals(that.annotationMap);
    }

    public int hashCode() {
        return this.annotationMap.hashCode();
    }

    public String toString() {
        return "AnnotationMap{annotationMap=" + this.annotationMap + '}';
    }
}

