/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.gcnv;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.FastMath;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CopyNumberPosteriorDistribution;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.IntervalCopyNumberGenotypingData;
import org.broadinstitute.hellbender.tools.copynumber.gcnv.GermlineCNVVariantComposer;
import org.broadinstitute.hellbender.tools.copynumber.gcnv.IntegerCopyNumberState;
import org.broadinstitute.hellbender.tools.spark.sv.utils.GATKSVVCFConstants;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;

public final class GermlineCNVIntervalVariantComposer
extends GermlineCNVVariantComposer<IntervalCopyNumberGenotypingData> {
    static final String CN = "CN";
    static final String CNLP = "CNLP";
    static final String CNQ = "CNQ";
    private final IntegerCopyNumberState refAutosomalCopyNumberState;
    private final Set<String> allosomalContigSet;

    public GermlineCNVIntervalVariantComposer(VariantContextWriter outputWriter, String sampleName, IntegerCopyNumberState refAutosomalCopyNumberState, Set<String> allosomalContigSet) {
        super(outputWriter, sampleName);
        this.refAutosomalCopyNumberState = Utils.nonNull(refAutosomalCopyNumberState);
        this.allosomalContigSet = Utils.nonNull(allosomalContigSet);
    }

    @Override
    public void composeVariantContextHeader(SAMSequenceDictionary sequenceDictionary, Set<VCFHeaderLine> vcfDefaultToolHeaderLines) {
        VCFHeader result = new VCFHeader(Collections.emptySet(), Collections.singletonList(this.sampleName));
        result.addMetaDataLine(new VCFHeaderLine(VCFHeaderVersion.VCF4_2.getFormatString(), VCFHeaderVersion.VCF4_2.getVersionString()));
        result.setSequenceDictionary(sequenceDictionary);
        vcfDefaultToolHeaderLines.forEach(arg_0 -> ((VCFHeader)result).addMetaDataLine(arg_0));
        result.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine("GT", 1, VCFHeaderLineType.Integer, "Genotype"));
        result.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine(CN, 1, VCFHeaderLineType.Integer, "Copy number maximum a posteriori value"));
        result.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine(CNLP, VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.Integer, "Copy number log posterior (in Phred-scale) rounded down"));
        result.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine(CNQ, 1, VCFHeaderLineType.Integer, "Genotype call quality as the difference between the best and second best phred-scaled log posterior scores"));
        result.addMetaDataLine((VCFHeaderLine)new VCFInfoHeaderLine("END", 1, VCFHeaderLineType.Integer, "End coordinate of the variant"));
        this.outputWriter.writeHeader(result);
    }

    @Override
    @VisibleForTesting
    VariantContext composeVariantContext(IntervalCopyNumberGenotypingData intervalCopyNumberGenotypingData) {
        IntegerCopyNumberState refCopyNumber;
        CopyNumberPosteriorDistribution copyNumberPosteriorDistribution = intervalCopyNumberGenotypingData.getCopyNumberPosteriorDistribution();
        List<Integer> copyNumberPLVector = GermlineCNVIntervalVariantComposer.calculateCopyNumberPLVector(copyNumberPosteriorDistribution);
        int copyNumberMAP = GermlineCNVIntervalVariantComposer.calculateMAPCopyNumberState(copyNumberPosteriorDistribution).getCopyNumber();
        int GQ = GermlineCNVIntervalVariantComposer.calculateGenotypeQuality(copyNumberPosteriorDistribution);
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder();
        variantContextBuilder.alleles((Collection)ALL_ALLELES);
        variantContextBuilder.chr(intervalCopyNumberGenotypingData.getContig());
        variantContextBuilder.start((long)intervalCopyNumberGenotypingData.getStart());
        variantContextBuilder.stop((long)intervalCopyNumberGenotypingData.getEnd());
        variantContextBuilder.id(String.format("CNV_%s_%d_%d", intervalCopyNumberGenotypingData.getContig(), intervalCopyNumberGenotypingData.getStart(), intervalCopyNumberGenotypingData.getEnd()));
        GenotypeBuilder genotypeBuilder = new GenotypeBuilder(this.sampleName);
        String contig = intervalCopyNumberGenotypingData.getContig();
        IntegerCopyNumberState integerCopyNumberState = refCopyNumber = this.allosomalContigSet.contains(contig) ? intervalCopyNumberGenotypingData.getBaselineIntegerCopyNumberState() : this.refAutosomalCopyNumberState;
        Allele allele = copyNumberMAP > refCopyNumber.getCopyNumber() ? GATKSVVCFConstants.DUP_ALLELE : (copyNumberMAP < refCopyNumber.getCopyNumber() ? GATKSVVCFConstants.DEL_ALLELE : REF_ALLELE);
        genotypeBuilder.alleles(Collections.singletonList(allele));
        genotypeBuilder.attribute(CN, (Object)copyNumberMAP);
        genotypeBuilder.attribute(CNLP, copyNumberPLVector);
        genotypeBuilder.attribute(CNQ, (Object)GQ);
        Genotype genotype = genotypeBuilder.make();
        variantContextBuilder.attribute("END", (Object)intervalCopyNumberGenotypingData.getEnd());
        variantContextBuilder.genotypes(new Genotype[]{genotype});
        return variantContextBuilder.make();
    }

    @VisibleForTesting
    static List<Integer> calculateCopyNumberPLVector(CopyNumberPosteriorDistribution copyNumberPosteriorDistribution) {
        Double largestLogProb = copyNumberPosteriorDistribution.getIntegerCopyNumberStateList().stream().mapToDouble(copyNumberPosteriorDistribution::getCopyNumberPosterior).max().orElse(Double.NaN);
        return copyNumberPosteriorDistribution.getIntegerCopyNumberStateList().stream().mapToDouble(copyNumberPosteriorDistribution::getCopyNumberPosterior).map(value -> value - largestLogProb).mapToInt(GermlineCNVIntervalVariantComposer::convertLogProbabilityToPhredScore).boxed().collect(Collectors.toList());
    }

    @VisibleForTesting
    static IntegerCopyNumberState calculateMAPCopyNumberState(CopyNumberPosteriorDistribution copyNumberPosteriorDistribution) {
        Optional<IntegerCopyNumberState> copyNumberStateMAP = copyNumberPosteriorDistribution.getIntegerCopyNumberStateList().stream().max(Comparator.comparingDouble(copyNumberPosteriorDistribution::getCopyNumberPosterior));
        return copyNumberStateMAP.get();
    }

    @VisibleForTesting
    static int calculateGenotypeQuality(CopyNumberPosteriorDistribution copyNumberPosteriorDistribution) {
        List sortedPosteriors = GermlineCNVIntervalVariantComposer.calculateCopyNumberPLVector(copyNumberPosteriorDistribution).stream().sorted().collect(Collectors.toList());
        Utils.validate((Integer)sortedPosteriors.get(0) == 0, "Something went wrong. Smallest copy number posterior score must be 0");
        return (Integer)sortedPosteriors.get(1);
    }

    private static int convertLogProbabilityToPhredScore(double posteriorProbInLogSpace) {
        return (int)FastMath.floor((double)(-10.0 * posteriorProbInLogSpace * MathUtils.LOG10_E));
    }
}

