/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.gcnv;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureReader;
import htsjdk.tribble.TribbleException;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.FastMath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.IntegerCopyNumberSegment;
import org.broadinstitute.hellbender.tools.copynumber.gcnv.GermlineCNVVariantComposer;
import org.broadinstitute.hellbender.tools.copynumber.gcnv.IntegerCopyNumberState;
import org.broadinstitute.hellbender.tools.spark.sv.utils.GATKSVVCFConstants;
import org.broadinstitute.hellbender.tools.spark.sv.utils.GATKSVVCFHeaderLines;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.reference.ReferenceUtils;
import org.broadinstitute.hellbender.utils.variant.GATKSVVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;

public final class GermlineCNVSegmentVariantComposer
extends GermlineCNVVariantComposer<IntegerCopyNumberSegment> {
    public static final String NP = "NP";
    public static final String QS = "QS";
    public static final String QA = "QA";
    public static final String QSS = "QSS";
    public static final String QSE = "QSE";
    public static final String SCHEMA_HEADER_KEY = "gcnvVcfSchemaVersion";
    public static final String CURRENT_SCHEMA_VERSION = "2.0";
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final IntegerCopyNumberState refAutosomalCopyNumberState;
    private final Set<String> allosomalContigSet;
    private final ReferenceSequenceFile reference;
    private final int dupeQSThreshold;
    private final int hetDelQSThreshold;
    private final int homDelQSThreshold;
    private final double siteFreqThreshold;
    private final File clusteredCohortVcf;
    private final FeatureReader<VariantContext> clusteredVCFReader;

    public GermlineCNVSegmentVariantComposer(VariantContextWriter outputWriter, String sampleName, IntegerCopyNumberState refAutosomalCopyNumberState, Set<String> allosomalContigSet, ReferenceSequenceFile reference, int dupeQSThreshold, int hetDelQSThreshold, int homDelQSThreshold, double siteFreqThreshold, File clusteredCohortVcf) {
        super(outputWriter, sampleName);
        this.refAutosomalCopyNumberState = Utils.nonNull(refAutosomalCopyNumberState);
        this.allosomalContigSet = Utils.nonNull(allosomalContigSet);
        this.reference = reference;
        this.dupeQSThreshold = dupeQSThreshold;
        this.hetDelQSThreshold = hetDelQSThreshold;
        this.homDelQSThreshold = homDelQSThreshold;
        this.siteFreqThreshold = siteFreqThreshold;
        this.clusteredCohortVcf = clusteredCohortVcf;
        if (clusteredCohortVcf != null) {
            try {
                this.clusteredVCFReader = AbstractFeatureReader.getFeatureReader((String)clusteredCohortVcf.getAbsolutePath(), (FeatureCodec)new VCFCodec());
            }
            catch (TribbleException ex) {
                throw new GATKException("Error - IO problem with file " + clusteredCohortVcf, ex);
            }
        } else {
            this.clusteredVCFReader = null;
        }
    }

    public GermlineCNVSegmentVariantComposer(VariantContextWriter outputWriter, String sampleName, IntegerCopyNumberState refAutosomalCopyNumberState, Set<String> allosomalContigSet, ReferenceSequenceFile reference) {
        this(outputWriter, sampleName, refAutosomalCopyNumberState, allosomalContigSet, reference, 0, 0, 0, 0.0, null);
    }

    @Override
    public void composeVariantContextHeader(SAMSequenceDictionary sequenceDictionary, Set<VCFHeaderLine> vcfDefaultToolHeaderLines) {
        VCFHeader result = new VCFHeader(Collections.emptySet(), Collections.singletonList(this.sampleName));
        result.addMetaDataLine(new VCFHeaderLine(VCFHeaderVersion.VCF4_2.getFormatString(), VCFHeaderVersion.VCF4_2.getVersionString()));
        vcfDefaultToolHeaderLines.forEach(arg_0 -> ((VCFHeader)result).addMetaDataLine(arg_0));
        result.addMetaDataLine(new VCFHeaderLine(SCHEMA_HEADER_KEY, CURRENT_SCHEMA_VERSION));
        result.setSequenceDictionary(sequenceDictionary);
        result.addMetaDataLine((VCFHeaderLine)GATKSVVCFHeaderLines.getInfoLine("SVTYPE"));
        result.addMetaDataLine((VCFHeaderLine)GATKSVVCFHeaderLines.getInfoLine("SVLEN"));
        result.addMetaDataLine((VCFHeaderLine)GATKVCFHeaderLines.getInfoLine("AC_Orig"));
        result.addMetaDataLine((VCFHeaderLine)GATKVCFHeaderLines.getInfoLine("AF_Orig"));
        result.addMetaDataLine((VCFHeaderLine)GATKVCFHeaderLines.getInfoLine("AN_Orig"));
        result.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine("GT", 1, VCFHeaderLineType.String, "Segment genotype"));
        result.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine("CN", 1, VCFHeaderLineType.Integer, "Segment most-likely copy-number call"));
        result.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine(NP, 1, VCFHeaderLineType.Integer, "Number of points (i.e. targets or bins) in the segment"));
        result.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine(QS, 1, VCFHeaderLineType.Integer, "Complementary Phred-scaled probability that at least one point (i.e. target or bin) in the segment agrees with the segment copy-number call"));
        result.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine(QA, 1, VCFHeaderLineType.Integer, "Complementary Phred-scaled probability that all points (i.e. targets or bins) in the segment agree with the segment copy-number call"));
        result.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine(QSS, 1, VCFHeaderLineType.Integer, "Complementary Phred-scaled probability that the segment start position is a genuine copy-number changepoint"));
        result.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine(QSE, 1, VCFHeaderLineType.Integer, "Complementary Phred-scaled probability that the segment end position is a genuine copy-number changepoint"));
        result.addMetaDataLine((VCFHeaderLine)new VCFInfoHeaderLine("END", 1, VCFHeaderLineType.Integer, "End coordinate of the variant"));
        result.addMetaDataLine((VCFHeaderLine)GATKSVVCFHeaderLines.getFilterLine("LOW_QS"));
        result.addMetaDataLine((VCFHeaderLine)GATKSVVCFHeaderLines.getFilterLine("FREQ"));
        this.outputWriter.writeHeader(result);
    }

    @Override
    @VisibleForTesting
    VariantContext composeVariantContext(IntegerCopyNumberSegment segment) {
        String contig = segment.getContig();
        int start = segment.getStart();
        int end = segment.getEnd();
        int copyNumberCall = segment.getCallIntegerCopyNumberState().getCopyNumber();
        Allele refAllele = this.reference == null ? REF_ALLELE : Allele.create((byte[])ReferenceUtils.getRefBaseAtPosition(this.reference, contig, start), (boolean)true);
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder();
        variantContextBuilder.chr(contig);
        variantContextBuilder.start((long)start);
        variantContextBuilder.stop((long)end);
        variantContextBuilder.id(String.format("CNV_%s_%d_%d", contig, start, end));
        GenotypeBuilder genotypeBuilder = new GenotypeBuilder(this.sampleName);
        IntegerCopyNumberState refCopyNumber = this.allosomalContigSet.contains(contig) ? segment.getBaselineIntegerCopyNumberState() : this.refAutosomalCopyNumberState;
        genotypeBuilder.alleles(GATKSVVariantContextUtils.makeGenotypeAllelesFromCopyNumber(copyNumberCall, refCopyNumber.getCopyNumber(), refAllele));
        genotypeBuilder.attribute("CN", (Object)copyNumberCall);
        genotypeBuilder.attribute(NP, (Object)segment.getNumPoints());
        genotypeBuilder.attribute(QS, (Object)FastMath.round((double)segment.getQualitySomeCalled()));
        genotypeBuilder.attribute(QA, (Object)FastMath.round((double)segment.getQualityAllCalled()));
        genotypeBuilder.attribute(QSS, (Object)FastMath.round((double)segment.getQualityStart()));
        genotypeBuilder.attribute(QSE, (Object)FastMath.round((double)segment.getQualityEnd()));
        HashSet<Allele> uniquifiedAlleles = new HashSet<Allele>();
        uniquifiedAlleles.add(refAllele);
        if (copyNumberCall > refCopyNumber.getCopyNumber()) {
            uniquifiedAlleles.add(GATKSVVCFConstants.DUP_ALLELE);
        } else if (copyNumberCall < refCopyNumber.getCopyNumber()) {
            uniquifiedAlleles.add(GATKSVVCFConstants.DEL_ALLELE);
        }
        variantContextBuilder.alleles(uniquifiedAlleles);
        variantContextBuilder.attribute("END", (Object)end);
        List<Double> alleleFrequency = new ArrayList<Double>();
        if (this.clusteredVCFReader != null) {
            try {
                List matches = this.clusteredVCFReader.query(segment.getContig(), segment.getStart(), segment.getEnd()).stream().filter(vc -> vc.getStart() == segment.getStart() && vc.getEnd() == segment.getEnd()).collect(Collectors.toList());
                if (!matches.isEmpty() && matches.get(0) != null) {
                    VariantContext cohortVC = (VariantContext)matches.get(0);
                    this.copyAnnotationIfPresent(cohortVC, variantContextBuilder, "AC", "AC_Orig");
                    this.copyAnnotationIfPresent(cohortVC, variantContextBuilder, "AF", "AF_Orig");
                    alleleFrequency = cohortVC.getAttributeAsDoubleList("AF", 0.0);
                    this.copyAnnotationIfPresent(cohortVC, variantContextBuilder, "AN", "AN_Orig");
                    this.copyAnnotationIfPresent(cohortVC, variantContextBuilder, "SVTYPE", "SVTYPE");
                    this.copyAnnotationIfPresent(cohortVC, variantContextBuilder, "SVLEN", "SVLEN");
                    if (cohortVC.hasGenotype(this.sampleName)) {
                        Genotype genotype = cohortVC.getGenotype(this.sampleName);
                        List cohortVCAlleles = genotype.getAlleles();
                        genotypeBuilder.alleles(cohortVCAlleles);
                        if (!uniquifiedAlleles.contains(cohortVC.getReference())) {
                            uniquifiedAlleles.remove(REF_ALLELE);
                            uniquifiedAlleles.add(cohortVC.getReference());
                        }
                        if (!genotype.isNoCall() && !uniquifiedAlleles.containsAll(cohortVCAlleles)) {
                            uniquifiedAlleles.addAll(cohortVCAlleles);
                        }
                        variantContextBuilder.alleles(uniquifiedAlleles);
                    }
                } else {
                    this.logger.warn("No matching cohort VC at " + segment.getContig() + ":" + segment.getStart());
                }
            }
            catch (IOException e) {
                throw new GATKException("Error querying file " + this.clusteredCohortVcf + " over interval " + new SimpleInterval(segment.getContig(), segment.getStart(), segment.getEnd()), e);
            }
        }
        Genotype genotype = genotypeBuilder.make();
        variantContextBuilder.genotypes(new Genotype[]{genotype});
        variantContextBuilder.log10PError(segment.getQualitySomeCalled() / -10.0);
        if (this.clusteredCohortVcf != null) {
            variantContextBuilder.filters(this.getInfoFilters(segment, alleleFrequency));
        }
        return variantContextBuilder.make();
    }

    private void copyAnnotationIfPresent(VariantContext cohortVC, VariantContextBuilder variantContextBuilder, String annotationKeyToQuery, String annotationKeyToWrite) {
        Object cohortValue;
        if (cohortVC.hasAttribute(annotationKeyToQuery) && (cohortValue = cohortVC.getAttribute(annotationKeyToQuery)) != null) {
            variantContextBuilder.attribute(annotationKeyToWrite, cohortValue);
        }
    }

    private Set<String> getInfoFilters(IntegerCopyNumberSegment segment, List<Double> alleleFrequency) {
        LinkedHashSet<String> returnFilters = new LinkedHashSet<String>();
        int qsThreshold = segment.getCallIntegerCopyNumberState().getCopyNumber() == 0 ? this.homDelQSThreshold : (segment.getCallIntegerCopyNumberState().getCopyNumber() > segment.getBaselineIntegerCopyNumberState().getCopyNumber() ? this.dupeQSThreshold : (segment.getCallIntegerCopyNumberState().getCopyNumber() < segment.getBaselineIntegerCopyNumberState().getCopyNumber() ? this.hetDelQSThreshold : 0));
        if (segment.getQualitySomeCalled() < (double)qsThreshold) {
            returnFilters.add("LOW_QS");
        }
        if (alleleFrequency.stream().allMatch(af -> af >= this.siteFreqThreshold)) {
            returnFilters.add("FREQ");
        }
        return returnFilters;
    }
}

