/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.gcnv;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.broadinstitute.hellbender.tools.spark.sv.utils.GATKSVVCFConstants;
import org.broadinstitute.hellbender.utils.Utils;

public abstract class GermlineCNVVariantComposer<DATA extends Locatable> {
    static final String VARIANT_PREFIX = "CNV";
    static final Allele REF_ALLELE = Allele.create((String)"N", (boolean)true);
    static final List<Allele> ALL_ALLELES = Arrays.asList(REF_ALLELE, GATKSVVCFConstants.DEL_ALLELE, GATKSVVCFConstants.DUP_ALLELE);
    protected final VariantContextWriter outputWriter;
    protected final String sampleName;

    GermlineCNVVariantComposer(VariantContextWriter outputWriter, String sampleName) {
        this.outputWriter = Utils.nonNull(outputWriter);
        this.sampleName = Utils.nonNull(sampleName);
    }

    abstract void composeVariantContextHeader(SAMSequenceDictionary var1, Set<VCFHeaderLine> var2);

    abstract VariantContext composeVariantContext(DATA var1);

    public final void writeAll(List<DATA> dataList) {
        for (Locatable data : dataList) {
            this.outputWriter.add(this.composeVariantContext(data));
        }
    }
}

