/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.gcnv;

import javax.annotation.Nonnull;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public final class IntegerCopyNumberState
implements Comparable<IntegerCopyNumberState> {
    private final int copyNumber;

    public IntegerCopyNumberState(int copyNumber) {
        this.copyNumber = ParamUtils.isPositiveOrZero(copyNumber, "The integer copy number state must be non-negative.");
    }

    public int getCopyNumber() {
        return this.copyNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.copyNumber == ((IntegerCopyNumberState)o).copyNumber;
    }

    @Override
    public int compareTo(@Nonnull IntegerCopyNumberState other) {
        return this.copyNumber - other.copyNumber;
    }

    public int hashCode() {
        return this.copyNumber;
    }

    public String toString() {
        return "COPY_NUMBER_" + Integer.toString(this.copyNumber);
    }
}

