/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.models;

import org.broadinstitute.hellbender.tools.copynumber.formats.CopyNumberFormatsUtils;

final class AlleleFractionGlobalParameters {
    private final double meanBias;
    private final double biasVariance;
    private final double outlierProbability;

    AlleleFractionGlobalParameters(double meanBias, double biasVariance, double outlierProbability) {
        this.meanBias = meanBias;
        this.biasVariance = biasVariance;
        this.outlierProbability = outlierProbability;
    }

    double getMeanBias() {
        return this.meanBias;
    }

    double getBiasVariance() {
        return this.biasVariance;
    }

    double getOutlierProbability() {
        return this.outlierProbability;
    }

    double getAlpha() {
        return this.meanBias * this.meanBias / this.biasVariance;
    }

    double getBeta() {
        return this.meanBias / this.biasVariance;
    }

    AlleleFractionGlobalParameters copyWithNewMeanBias(double newMeanBias) {
        return new AlleleFractionGlobalParameters(newMeanBias, this.biasVariance, this.outlierProbability);
    }

    AlleleFractionGlobalParameters copyWithNewBiasVariance(double newBiasVariance) {
        return new AlleleFractionGlobalParameters(this.meanBias, newBiasVariance, this.outlierProbability);
    }

    AlleleFractionGlobalParameters copyWithNewOutlierProbability(double newOutlierProbability) {
        return new AlleleFractionGlobalParameters(this.meanBias, this.biasVariance, newOutlierProbability);
    }

    public String toString() {
        return "AlleleFractionGlobalParameters{meanBias=" + CopyNumberFormatsUtils.formatDouble(this.meanBias) + ", biasVariance=" + CopyNumberFormatsUtils.formatDouble(this.biasVariance) + ", outlierProbability=" + CopyNumberFormatsUtils.formatDouble(this.outlierProbability) + '}';
    }
}

