/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.models;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionGlobalParameters;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionSegmentedData;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionState;
import org.broadinstitute.hellbender.tools.copynumber.models.FunctionCache;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.NaturalLogUtils;

final class AlleleFractionLikelihoods {
    private static final double EPSILON = 1.0E-10;
    private static final FunctionCache<Double> logGammaCache = new FunctionCache<Double>(Gamma::logGamma);
    private static final FunctionCache<Double> logCache = new FunctionCache<Double>(AlleleFractionLikelihoods::log);

    private AlleleFractionLikelihoods() {
    }

    static double hetLogLikelihood(AlleleFractionGlobalParameters parameters, double minorFraction, AlleleFractionSegmentedData.IndexedAllelicCount allelicCount) {
        double alpha = parameters.getAlpha();
        double beta = parameters.getBeta();
        double pi = parameters.getOutlierProbability();
        double logPi = logCache.computeIfAbsent(pi);
        double logNotPi = logCache.computeIfAbsent((1.0 - pi) / 2.0);
        double logcCommon = alpha * logCache.computeIfAbsent(beta) - logGammaCache.computeIfAbsent(alpha);
        double majorFraction = 1.0 - minorFraction;
        double logMinorFraction = logCache.computeIfAbsent(minorFraction);
        double logMajorFraction = logCache.computeIfAbsent(majorFraction);
        int a = allelicCount.getAltReadCount();
        int r = allelicCount.getRefReadCount();
        int n = a + r;
        double lambda0AltMinor = AlleleFractionLikelihoods.biasPosteriorMode(alpha, beta, minorFraction, a, r);
        double kappaAltMinor = AlleleFractionLikelihoods.biasPosteriorCurvature(alpha, minorFraction, r, n, lambda0AltMinor);
        double rhoAltMinor = AlleleFractionLikelihoods.biasPosteriorEffectiveAlpha(lambda0AltMinor, kappaAltMinor);
        double tauAltMinor = AlleleFractionLikelihoods.biasPosteriorEffectiveBeta(lambda0AltMinor, kappaAltMinor);
        double logcAltMinor = logcCommon + (double)a * logMinorFraction + (double)r * logMajorFraction + ((double)r + alpha - rhoAltMinor) * AlleleFractionLikelihoods.log(lambda0AltMinor) + (tauAltMinor - beta) * lambda0AltMinor - (double)n * AlleleFractionLikelihoods.log(minorFraction + majorFraction * lambda0AltMinor);
        double altMinorLogLikelihood = logNotPi + logcAltMinor + Gamma.logGamma((double)rhoAltMinor) - rhoAltMinor * AlleleFractionLikelihoods.log(tauAltMinor);
        double lambda0RefMinor = AlleleFractionLikelihoods.biasPosteriorMode(alpha, beta, majorFraction, a, r);
        double kappaRefMinor = AlleleFractionLikelihoods.biasPosteriorCurvature(alpha, majorFraction, r, n, lambda0RefMinor);
        double rhoRefMinor = AlleleFractionLikelihoods.biasPosteriorEffectiveAlpha(lambda0RefMinor, kappaRefMinor);
        double tauRefMinor = AlleleFractionLikelihoods.biasPosteriorEffectiveBeta(lambda0RefMinor, kappaRefMinor);
        double logcRefMinor = logcCommon + (double)a * logMajorFraction + (double)r * logMinorFraction + ((double)r + alpha - rhoRefMinor) * AlleleFractionLikelihoods.log(lambda0RefMinor) + (tauRefMinor - beta) * lambda0RefMinor - (double)n * AlleleFractionLikelihoods.log(majorFraction + minorFraction * lambda0RefMinor);
        double refMinorLogLikelihood = logNotPi + logcRefMinor + Gamma.logGamma((double)rhoRefMinor) - rhoRefMinor * AlleleFractionLikelihoods.log(tauRefMinor);
        double outlierLogLikelihood = logPi + MathUtils.log10ToLog(MathUtils.log10Factorial(a) + MathUtils.log10Factorial(r) - MathUtils.log10Factorial(a + r + 1));
        return NaturalLogUtils.logSumExp(altMinorLogLikelihood, refMinorLogLikelihood, outlierLogLikelihood);
    }

    static double segmentLogLikelihood(AlleleFractionGlobalParameters parameters, double minorFraction, List<AlleleFractionSegmentedData.IndexedAllelicCount> allelicCountsInSegment) {
        return allelicCountsInSegment.stream().mapToDouble(allelicCount -> AlleleFractionLikelihoods.hetLogLikelihood(parameters, minorFraction, allelicCount)).sum();
    }

    static double logLikelihood(AlleleFractionGlobalParameters parameters, AlleleFractionState.MinorFractions minorFractions, AlleleFractionSegmentedData data) {
        return IntStream.range(0, data.getNumSegments()).mapToDouble(segment -> AlleleFractionLikelihoods.segmentLogLikelihood(parameters, (Double)minorFractions.get(segment), data.getIndexedAllelicCountsInSegment(segment))).sum();
    }

    private static double biasPosteriorMode(double alpha, double beta, double f, int a, int r) {
        double w = (1.0 - f) * ((double)a - alpha + 1.0) + beta * f;
        return Math.max((FastMath.sqrt((double)(w * w + 4.0 * beta * f * (1.0 - f) * ((double)r + alpha - 1.0))) - w) / (2.0 * beta * (1.0 - f)), 1.0E-10);
    }

    private static double biasPosteriorCurvature(double alpha, double f, int r, int n, double lambda0) {
        double y = (1.0 - f) / (f + (1.0 - f) * lambda0);
        return (double)n * y * y - ((double)r + alpha - 1.0) / (lambda0 * lambda0);
    }

    private static double biasPosteriorEffectiveAlpha(double lambda0, double kappa) {
        return Math.max(1.0 - kappa * lambda0 * lambda0, 1.0E-10);
    }

    private static double biasPosteriorEffectiveBeta(double lambda0, double kappa) {
        return Math.max(-kappa * lambda0, 1.0E-10);
    }

    private static double log(double x) {
        return FastMath.log((double)Math.max(1.0E-10, x));
    }
}

