/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AllelicCountCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.ParameterDecileCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.SimpleIntervalCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.LocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SimpleSampleMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.ModeledSegment;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionGlobalParameters;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionInitializer;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionLikelihoods;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionParameter;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionPrior;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionSamplers;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionSegmentedData;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionState;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.mcmc.DecileCollection;
import org.broadinstitute.hellbender.utils.mcmc.GibbsSampler;
import org.broadinstitute.hellbender.utils.mcmc.ParameterizedModel;

public final class AlleleFractionModeller {
    private static final double MAX_REASONABLE_MEAN_BIAS = 5.0;
    private static final double MAX_REASONABLE_BIAS_VARIANCE = 0.5;
    private static final double MAX_REASONABLE_OUTLIER_PROBABILITY = 0.15;
    private static final double MIN_MINOR_FRACTION_SAMPLING_WIDTH = 0.001;
    private final SampleLocatableMetadata metadata;
    private final ParameterizedModel<AlleleFractionParameter, AlleleFractionState, AlleleFractionSegmentedData> model;
    private final List<Double> meanBiasSamples = new ArrayList<Double>();
    private final List<Double> biasVarianceSamples = new ArrayList<Double>();
    private final List<Double> outlierProbabilitySamples = new ArrayList<Double>();
    private final List<AlleleFractionState.MinorFractions> minorFractionsSamples = new ArrayList<AlleleFractionState.MinorFractions>();

    AlleleFractionModeller(AllelicCountCollection allelicCounts, SimpleIntervalCollection segments, AlleleFractionPrior prior) {
        Utils.nonNull(allelicCounts);
        Utils.nonNull(segments);
        Utils.validateArg(((SampleLocatableMetadata)allelicCounts.getMetadata()).getSequenceDictionary().equals((Object)((LocatableMetadata)segments.getMetadata()).getSequenceDictionary()), "Metadata of the allelic counts and the segments do not match.");
        Utils.nonNull(prior);
        this.metadata = (SampleLocatableMetadata)allelicCounts.getMetadata();
        AlleleFractionSegmentedData data = new AlleleFractionSegmentedData(allelicCounts, segments);
        AlleleFractionState initialState = new AlleleFractionInitializer(data).getInitializedState();
        AlleleFractionGlobalParameters initialParameters = initialState.globalParameters();
        AlleleFractionState.MinorFractions initialMinorFractions = initialState.minorFractions();
        double meanBiasSamplingWidths = AlleleFractionModeller.approximatePosteriorWidthAtMode(meanBias -> AlleleFractionLikelihoods.logLikelihood(initialParameters.copyWithNewMeanBias((double)meanBias), initialMinorFractions, data), initialParameters.getMeanBias());
        double biasVarianceSamplingWidths = AlleleFractionModeller.approximatePosteriorWidthAtMode(biasVariance -> AlleleFractionLikelihoods.logLikelihood(initialParameters.copyWithNewBiasVariance((double)biasVariance), initialMinorFractions, data), initialParameters.getBiasVariance());
        double outlierProbabilitySamplingWidths = AlleleFractionModeller.approximatePosteriorWidthAtMode(outlierProbability -> AlleleFractionLikelihoods.logLikelihood(initialParameters.copyWithNewOutlierProbability((double)outlierProbability), initialMinorFractions, data), initialParameters.getOutlierProbability());
        List<Double> minorFractionsSliceSamplingWidths = IntStream.range(0, data.getNumSegments()).boxed().map(segment -> AlleleFractionModeller.approximatePosteriorWidthAtMode(f -> AlleleFractionLikelihoods.segmentLogLikelihood(initialParameters, f, data.getIndexedAllelicCountsInSegment((int)segment)), (Double)initialMinorFractions.get((int)segment))).map(w -> Math.max(w, 0.001)).collect(Collectors.toList());
        AlleleFractionSamplers.MeanBiasSampler meanBiasSampler = new AlleleFractionSamplers.MeanBiasSampler(5.0, meanBiasSamplingWidths);
        AlleleFractionSamplers.BiasVarianceSampler biasVarianceSampler = new AlleleFractionSamplers.BiasVarianceSampler(0.5, biasVarianceSamplingWidths);
        AlleleFractionSamplers.OutlierProbabilitySampler outlierProbabilitySampler = new AlleleFractionSamplers.OutlierProbabilitySampler(0.15, outlierProbabilitySamplingWidths);
        AlleleFractionSamplers.MinorFractionsSampler minorFractionsSampler = new AlleleFractionSamplers.MinorFractionsSampler(prior, minorFractionsSliceSamplingWidths);
        this.model = new ParameterizedModel.GibbsBuilder<AlleleFractionParameter, AlleleFractionState, AlleleFractionSegmentedData>(initialState, data).addParameterSampler(AlleleFractionParameter.MEAN_BIAS, meanBiasSampler, Double.class).addParameterSampler(AlleleFractionParameter.BIAS_VARIANCE, biasVarianceSampler, Double.class).addParameterSampler(AlleleFractionParameter.OUTLIER_PROBABILITY, outlierProbabilitySampler, Double.class).addParameterSampler(AlleleFractionParameter.MINOR_ALLELE_FRACTIONS, minorFractionsSampler, AlleleFractionState.MinorFractions.class).build();
    }

    void fitMCMC(int numSamples, int numBurnIn) {
        GibbsSampler<AlleleFractionParameter, AlleleFractionState, AlleleFractionSegmentedData> gibbsSampler = new GibbsSampler<AlleleFractionParameter, AlleleFractionState, AlleleFractionSegmentedData>(numSamples, this.model);
        gibbsSampler.runMCMC();
        this.meanBiasSamples.addAll(gibbsSampler.getSamples(AlleleFractionParameter.MEAN_BIAS, Double.class, numBurnIn));
        this.biasVarianceSamples.addAll(gibbsSampler.getSamples(AlleleFractionParameter.BIAS_VARIANCE, Double.class, numBurnIn));
        this.outlierProbabilitySamples.addAll(gibbsSampler.getSamples(AlleleFractionParameter.OUTLIER_PROBABILITY, Double.class, numBurnIn));
        this.minorFractionsSamples.addAll(gibbsSampler.getSamples(AlleleFractionParameter.MINOR_ALLELE_FRACTIONS, AlleleFractionState.MinorFractions.class, numBurnIn));
    }

    List<Double> getMeanBiasSamples() {
        return Collections.unmodifiableList(this.meanBiasSamples);
    }

    List<Double> getBiasVarianceSamples() {
        return Collections.unmodifiableList(this.biasVarianceSamples);
    }

    List<Double> getOutlierProbabilitySamples() {
        return Collections.unmodifiableList(this.outlierProbabilitySamples);
    }

    List<AlleleFractionState.MinorFractions> getMinorFractionsSamples() {
        return Collections.unmodifiableList(this.minorFractionsSamples);
    }

    List<ModeledSegment.SimplePosteriorSummary> getMinorAlleleFractionsPosteriorSummaries() {
        if (this.minorFractionsSamples.isEmpty()) {
            throw new IllegalStateException("Attempted to get posterior summaries for minor-allele fractions before MCMC was performed.");
        }
        int numSegments = this.minorFractionsSamples.get(0).size();
        ArrayList<ModeledSegment.SimplePosteriorSummary> posteriorSummaries = new ArrayList<ModeledSegment.SimplePosteriorSummary>(numSegments);
        int segmentIndex = 0;
        while (segmentIndex < numSegments) {
            int j = segmentIndex++;
            List<Double> minorFractionSamples = this.minorFractionsSamples.stream().map(s -> (Double)s.get(j)).collect(Collectors.toList());
            posteriorSummaries.add(new ModeledSegment.SimplePosteriorSummary(minorFractionSamples));
        }
        return posteriorSummaries;
    }

    ParameterDecileCollection<AlleleFractionParameter> getGlobalParameterDeciles() {
        if (this.meanBiasSamples.isEmpty()) {
            throw new IllegalStateException("Attempted to get posterior summaries for global parameters before MCMC was performed.");
        }
        LinkedHashMap<AlleleFractionParameter, DecileCollection> parameterToDecilesMap = new LinkedHashMap<AlleleFractionParameter, DecileCollection>();
        parameterToDecilesMap.put(AlleleFractionParameter.MEAN_BIAS, new DecileCollection(this.meanBiasSamples));
        parameterToDecilesMap.put(AlleleFractionParameter.BIAS_VARIANCE, new DecileCollection(this.biasVarianceSamples));
        parameterToDecilesMap.put(AlleleFractionParameter.OUTLIER_PROBABILITY, new DecileCollection(this.outlierProbabilitySamples));
        return new ParameterDecileCollection<AlleleFractionParameter>(new SimpleSampleMetadata(this.metadata.getSampleName()), parameterToDecilesMap, AlleleFractionParameter.class);
    }

    private static double approximatePosteriorWidthAtMode(Function<Double, Double> logPDF, double mode) {
        double absMode = Math.abs(mode);
        double epsilon = Math.min(1.0E-6, absMode / 2.0);
        double defaultWidth = absMode / 10.0;
        double secondDerivative = (logPDF.apply(mode + epsilon) - 2.0 * logPDF.apply(mode) + logPDF.apply(mode - epsilon)) / (epsilon * epsilon);
        return secondDerivative < 0.0 ? Math.sqrt(-1.0 / secondDerivative) : defaultWidth;
    }
}

