/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.models;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionLikelihoods;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionParameter;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionPrior;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionSegmentedData;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionState;
import org.broadinstitute.hellbender.utils.mcmc.MinibatchSliceSampler;
import org.broadinstitute.hellbender.utils.mcmc.ParameterSampler;

final class AlleleFractionSamplers {
    private static final Logger logger = LogManager.getLogger(AlleleFractionSamplers.class);
    private static final Function<Double, Double> UNIFORM_LOG_PRIOR = x -> 0.0;
    private static final int GLOBAL_MINIBATCH_SIZE = 1000;
    private static final int SEGMENT_MINIBATCH_SIZE = 10;
    private static final double APPROX_THRESHOLD = 0.1;

    private AlleleFractionSamplers() {
    }

    static final class MinorFractionsSampler
    implements ParameterSampler<AlleleFractionState.MinorFractions, AlleleFractionParameter, AlleleFractionState, AlleleFractionSegmentedData> {
        private static double MIN_MINOR_FRACTION = 0.0;
        private static double MAX_MINOR_FRACTION = 0.5;
        private static final double PRIOR_BETA = 1.0;
        private final Function<Double, Double> logPrior = f -> new BetaDistribution(null, prior.getMinorAlleleFractionPriorAlpha(), 1.0).logDensity(2.0 * f);
        private final List<Double> sliceSamplingWidths;

        MinorFractionsSampler(AlleleFractionPrior prior, List<Double> sliceSamplingWidths) {
            this.sliceSamplingWidths = sliceSamplingWidths;
        }

        @Override
        public AlleleFractionState.MinorFractions sample(RandomGenerator rng, AlleleFractionState state, AlleleFractionSegmentedData data) {
            ArrayList<Double> minorFractions = new ArrayList<Double>(data.getNumSegments());
            BiFunction<AlleleFractionSegmentedData.IndexedAllelicCount, Double, Double> logConditionalPDF = (iac, newMinorFraction) -> AlleleFractionLikelihoods.hetLogLikelihood(state.globalParameters(), newMinorFraction, iac);
            for (int segmentIndex = 0; segmentIndex < data.getNumSegments(); ++segmentIndex) {
                logger.debug(String.format("Sampling minor fraction for segment %d...", segmentIndex));
                List<AlleleFractionSegmentedData.IndexedAllelicCount> allelicCountsInSegment = data.getIndexedAllelicCountsInSegment(segmentIndex);
                if (allelicCountsInSegment.isEmpty()) {
                    minorFractions.add(Double.NaN);
                    continue;
                }
                MinibatchSliceSampler<AlleleFractionSegmentedData.IndexedAllelicCount> sampler = new MinibatchSliceSampler<AlleleFractionSegmentedData.IndexedAllelicCount>(rng, allelicCountsInSegment, this.logPrior, logConditionalPDF, MIN_MINOR_FRACTION, MAX_MINOR_FRACTION, this.sliceSamplingWidths.get(segmentIndex), 10, 0.1);
                minorFractions.add(sampler.sample(state.segmentMinorFraction(segmentIndex)));
            }
            return new AlleleFractionState.MinorFractions((List<Double>)minorFractions);
        }
    }

    static final class OutlierProbabilitySampler
    implements ParameterSampler<Double, AlleleFractionParameter, AlleleFractionState, AlleleFractionSegmentedData> {
        private static final double MIN_OUTLIER_PROBABILITY = 0.0;
        private final double maxOutlierProbability;
        private final double outlierProbabilitySliceSamplingWidth;

        OutlierProbabilitySampler(double maxOutlierProbability, double outlierProbabilitySliceSamplingWidth) {
            this.maxOutlierProbability = maxOutlierProbability;
            this.outlierProbabilitySliceSamplingWidth = outlierProbabilitySliceSamplingWidth;
        }

        @Override
        public Double sample(RandomGenerator rng, AlleleFractionState state, AlleleFractionSegmentedData data) {
            logger.debug("Sampling outlier probability...");
            BiFunction<AlleleFractionSegmentedData.IndexedAllelicCount, Double, Double> logConditionalPDF = (iac, newOutlierProbability) -> AlleleFractionLikelihoods.hetLogLikelihood(state.globalParameters().copyWithNewOutlierProbability((double)newOutlierProbability), state.segmentMinorFraction(iac.getSegmentIndex()), iac);
            return new MinibatchSliceSampler<AlleleFractionSegmentedData.IndexedAllelicCount>(rng, data.getIndexedAllelicCounts(), UNIFORM_LOG_PRIOR, logConditionalPDF, 0.0, this.maxOutlierProbability, this.outlierProbabilitySliceSamplingWidth, 1000, 0.1).sample(state.globalParameters().getOutlierProbability());
        }
    }

    static final class BiasVarianceSampler
    implements ParameterSampler<Double, AlleleFractionParameter, AlleleFractionState, AlleleFractionSegmentedData> {
        private static final double MIN_BIAS_VARIANCE = 1.0E-10;
        private final double maxBiasVariance;
        private final double biasVarianceSliceSamplingWidth;

        BiasVarianceSampler(double maxBiasVariance, double biasVarianceSliceSamplingWidth) {
            this.maxBiasVariance = maxBiasVariance;
            this.biasVarianceSliceSamplingWidth = biasVarianceSliceSamplingWidth;
        }

        @Override
        public Double sample(RandomGenerator rng, AlleleFractionState state, AlleleFractionSegmentedData data) {
            logger.debug("Sampling bias variance...");
            BiFunction<AlleleFractionSegmentedData.IndexedAllelicCount, Double, Double> logConditionalPDF = (iac, newBiasVariance) -> AlleleFractionLikelihoods.hetLogLikelihood(state.globalParameters().copyWithNewBiasVariance((double)newBiasVariance), state.segmentMinorFraction(iac.getSegmentIndex()), iac);
            return new MinibatchSliceSampler<AlleleFractionSegmentedData.IndexedAllelicCount>(rng, data.getIndexedAllelicCounts(), UNIFORM_LOG_PRIOR, logConditionalPDF, 1.0E-10, this.maxBiasVariance, this.biasVarianceSliceSamplingWidth, 1000, 0.1).sample(state.globalParameters().getBiasVariance());
        }
    }

    static final class MeanBiasSampler
    implements ParameterSampler<Double, AlleleFractionParameter, AlleleFractionState, AlleleFractionSegmentedData> {
        private static final double MIN_MEAN_BIAS = 0.0;
        private final double maxMeanBias;
        private final double meanBiasSliceSamplingWidth;

        MeanBiasSampler(double maxMeanBias, double meanBiasSliceSamplingWidth) {
            this.maxMeanBias = maxMeanBias;
            this.meanBiasSliceSamplingWidth = meanBiasSliceSamplingWidth;
        }

        @Override
        public Double sample(RandomGenerator rng, AlleleFractionState state, AlleleFractionSegmentedData data) {
            logger.debug("Sampling mean bias...");
            BiFunction<AlleleFractionSegmentedData.IndexedAllelicCount, Double, Double> logConditionalPDF = (iac, newMeanBias) -> AlleleFractionLikelihoods.hetLogLikelihood(state.globalParameters().copyWithNewMeanBias((double)newMeanBias), state.segmentMinorFraction(iac.getSegmentIndex()), iac);
            return new MinibatchSliceSampler<AlleleFractionSegmentedData.IndexedAllelicCount>(rng, data.getIndexedAllelicCounts(), UNIFORM_LOG_PRIOR, logConditionalPDF, 0.0, this.maxMeanBias, this.meanBiasSliceSamplingWidth, 1000, 0.1).sample(state.globalParameters().getMeanBias());
        }
    }
}

