/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.models;

import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AllelicCountCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.SimpleIntervalCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.AllelicCount;
import org.broadinstitute.hellbender.utils.IndexRange;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.mcmc.DataCollection;

final class AlleleFractionSegmentedData
implements DataCollection {
    private final AllelicCountCollection allelicCounts;
    private final SimpleIntervalCollection segments;
    private final List<IndexedAllelicCount> indexedAllelicCounts;
    private final List<IndexRange> indexRangesPerSegment;

    AlleleFractionSegmentedData(AllelicCountCollection allelicCounts, SimpleIntervalCollection segments) {
        this.allelicCounts = Utils.nonNull(allelicCounts);
        this.segments = Utils.nonNull(segments);
        ArrayList indexedAllelicCounts = new ArrayList(allelicCounts.size());
        ArrayList<IndexRange> indexRangesPerSegment = new ArrayList<IndexRange>(segments.size());
        OverlapDetector allelicCountOverlapDetector = allelicCounts.getOverlapDetector();
        Comparator<Locatable> comparator = allelicCounts.getComparator();
        int startIndex = 0;
        int segmentIndex = 0;
        while (segmentIndex < segments.size()) {
            SimpleInterval segment = (SimpleInterval)segments.getRecords().get(segmentIndex);
            List allelicCountsInSegment = allelicCountOverlapDetector.getOverlaps((Locatable)segment).stream().sorted(comparator).collect(Collectors.toList());
            int segmentStartIndex = startIndex;
            int si = segmentIndex++;
            IntStream.range(0, allelicCountsInSegment.size()).boxed().map(i -> new IndexedAllelicCount((AllelicCount)allelicCountsInSegment.get((int)i), segmentStartIndex + i, si)).forEach(indexedAllelicCounts::add);
            indexRangesPerSegment.add(new IndexRange(segmentStartIndex, segmentStartIndex + allelicCountsInSegment.size()));
            startIndex += allelicCountsInSegment.size();
        }
        this.indexedAllelicCounts = Collections.unmodifiableList(indexedAllelicCounts);
        this.indexRangesPerSegment = Collections.unmodifiableList(indexRangesPerSegment);
    }

    AllelicCountCollection getAllelicCounts() {
        return this.allelicCounts;
    }

    SimpleIntervalCollection getSegments() {
        return this.segments;
    }

    int getNumSegments() {
        return this.segments.size();
    }

    int getNumPoints() {
        return this.allelicCounts.size();
    }

    List<IndexedAllelicCount> getIndexedAllelicCounts() {
        return this.indexedAllelicCounts;
    }

    List<IndexedAllelicCount> getIndexedAllelicCountsInSegment(int segmentIndex) {
        return this.indexedAllelicCounts.subList(this.indexRangesPerSegment.get(segmentIndex).getStart(), this.indexRangesPerSegment.get(segmentIndex).getEnd());
    }

    static final class IndexedAllelicCount
    extends AllelicCount {
        private final int index;
        private final int segmentIndex;

        private IndexedAllelicCount(AllelicCount allelicCount, int index, int segmentIndex) {
            super(allelicCount.getInterval(), allelicCount.getRefReadCount(), allelicCount.getAltReadCount(), allelicCount.getRefNucleotide(), allelicCount.getAltNucleotide());
            this.index = index;
            this.segmentIndex = segmentIndex;
        }

        int getIndex() {
            return this.index;
        }

        int getSegmentIndex() {
            return this.segmentIndex;
        }
    }
}

