/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionGlobalParameters;
import org.broadinstitute.hellbender.tools.copynumber.models.AlleleFractionParameter;
import org.broadinstitute.hellbender.utils.mcmc.Parameter;
import org.broadinstitute.hellbender.utils.mcmc.ParameterizedState;

final class AlleleFractionState
extends ParameterizedState<AlleleFractionParameter> {
    AlleleFractionState(double meanBias, double biasVariance, double outlierProbability, MinorFractions minorFractions) {
        super(Arrays.asList(new Parameter<AlleleFractionParameter, Double>(AlleleFractionParameter.MEAN_BIAS, meanBias), new Parameter<AlleleFractionParameter, Double>(AlleleFractionParameter.BIAS_VARIANCE, biasVariance), new Parameter<AlleleFractionParameter, Double>(AlleleFractionParameter.OUTLIER_PROBABILITY, outlierProbability), new Parameter<AlleleFractionParameter, MinorFractions>(AlleleFractionParameter.MINOR_ALLELE_FRACTIONS, minorFractions)));
    }

    double meanBias() {
        return this.get(AlleleFractionParameter.MEAN_BIAS, Double.class);
    }

    double biasVariance() {
        return this.get(AlleleFractionParameter.BIAS_VARIANCE, Double.class);
    }

    double outlierProbability() {
        return this.get(AlleleFractionParameter.OUTLIER_PROBABILITY, Double.class);
    }

    double segmentMinorFraction(int segment) {
        return (Double)this.get(AlleleFractionParameter.MINOR_ALLELE_FRACTIONS, MinorFractions.class).get(segment);
    }

    AlleleFractionGlobalParameters globalParameters() {
        return new AlleleFractionGlobalParameters(this.meanBias(), this.biasVariance(), this.outlierProbability());
    }

    MinorFractions minorFractions() {
        return this.get(AlleleFractionParameter.MINOR_ALLELE_FRACTIONS, MinorFractions.class);
    }

    static final class MinorFractions
    extends ArrayList<Double> {
        private static final long serialVersionUID = 1029384756L;

        MinorFractions(int numSegments) {
            super(numSegments);
        }

        MinorFractions(List<Double> minorFractions) {
            super(new ArrayList<Double>(minorFractions));
        }
    }
}

