/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.CopyRatioCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.ParameterDecileCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.SimpleIntervalCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.LocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SimpleSampleMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.ModeledSegment;
import org.broadinstitute.hellbender.tools.copynumber.models.CopyRatioParameter;
import org.broadinstitute.hellbender.tools.copynumber.models.CopyRatioSamplers;
import org.broadinstitute.hellbender.tools.copynumber.models.CopyRatioSegmentedData;
import org.broadinstitute.hellbender.tools.copynumber.models.CopyRatioState;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.mcmc.DecileCollection;
import org.broadinstitute.hellbender.utils.mcmc.GibbsSampler;
import org.broadinstitute.hellbender.utils.mcmc.ParameterizedModel;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public final class CopyRatioModeller {
    private static final double EPSILON = 1.0E-6;
    static final double LOG2_COPY_RATIO_MIN = -50.0;
    static final double LOG2_COPY_RATIO_MAX = 10.0;
    private static final double LOG2_COPY_RATIO_RANGE = 60.0;
    private static final double VARIANCE_MIN = 1.0E-6;
    private static final double OUTLIER_PROBABILITY_INITIAL = 0.05;
    private static final double OUTLIER_PROBABILITY_PRIOR_ALPHA = 5.0;
    private static final double OUTLIER_PROBABILITY_PRIOR_BETA = 95.0;
    private final SampleLocatableMetadata metadata;
    private final ParameterizedModel<CopyRatioParameter, CopyRatioState, CopyRatioSegmentedData> model;
    private final List<Double> varianceSamples = new ArrayList<Double>();
    private final List<Double> outlierProbabilitySamples = new ArrayList<Double>();
    private final List<CopyRatioState.SegmentMeans> segmentMeansSamples = new ArrayList<CopyRatioState.SegmentMeans>();

    CopyRatioModeller(CopyRatioCollection copyRatios, SimpleIntervalCollection segments) {
        Utils.nonNull(copyRatios);
        Utils.nonNull(segments);
        Utils.validateArg(((SampleLocatableMetadata)copyRatios.getMetadata()).getSequenceDictionary().equals((Object)((LocatableMetadata)segments.getMetadata()).getSequenceDictionary()), "Metadata of the copy ratios and the segments do not match.");
        Utils.nonEmpty(segments.getRecords());
        this.metadata = (SampleLocatableMetadata)copyRatios.getMetadata();
        CopyRatioSegmentedData data = new CopyRatioSegmentedData(copyRatios, segments);
        double dataRangeOrNaN = data.getMaxLog2CopyRatioValue() - data.getMinLog2CopyRatioValue();
        double dataRange = Double.isNaN(dataRangeOrNaN) ? 60.0 : dataRangeOrNaN;
        double varianceEstimateOrNaN = data.estimateVariance();
        double varianceEstimate = Double.isNaN(varianceEstimateOrNaN) ? 1.0E-6 : Math.max(varianceEstimateOrNaN, 1.0E-6);
        double varianceSliceSamplingWidth = 2.0 * varianceEstimate;
        double varianceMax = Math.max(10.0 * varianceEstimate, dataRange * dataRange);
        double meanSliceSamplingWidth = Math.sqrt(varianceEstimate * (double)data.getNumSegments() / (double)data.getNumPoints());
        List<Double> segmentMeans = data.estimateSegmentMeans().stream().map(m -> Math.max(-50.0, Math.min(10.0, m))).collect(Collectors.toList());
        double outlierUniformLogLikelihood = -Math.log(dataRange);
        CopyRatioState initialState = new CopyRatioState(varianceEstimate, 0.05, new CopyRatioState.SegmentMeans(segmentMeans), new CopyRatioState.OutlierIndicators(Collections.nCopies(data.getNumPoints(), false)));
        CopyRatioSamplers.VarianceSampler varianceSampler = new CopyRatioSamplers.VarianceSampler(1.0E-6, varianceMax, varianceSliceSamplingWidth);
        CopyRatioSamplers.OutlierProbabilitySampler outlierProbabilitySampler = new CopyRatioSamplers.OutlierProbabilitySampler(5.0, 95.0);
        CopyRatioSamplers.SegmentMeansSampler segmentMeansSampler = new CopyRatioSamplers.SegmentMeansSampler(-50.0, 10.0, meanSliceSamplingWidth);
        CopyRatioSamplers.OutlierIndicatorsSampler outlierIndicatorsSampler = new CopyRatioSamplers.OutlierIndicatorsSampler(outlierUniformLogLikelihood);
        this.model = new ParameterizedModel.GibbsBuilder<CopyRatioParameter, CopyRatioState, CopyRatioSegmentedData>(initialState, data).addParameterSampler(CopyRatioParameter.VARIANCE, varianceSampler, Double.class).addParameterSampler(CopyRatioParameter.OUTLIER_PROBABILITY, outlierProbabilitySampler, Double.class).addParameterSampler(CopyRatioParameter.SEGMENT_MEANS, segmentMeansSampler, CopyRatioState.SegmentMeans.class).addParameterSampler(CopyRatioParameter.OUTLIER_INDICATORS, outlierIndicatorsSampler, CopyRatioState.OutlierIndicators.class).build();
    }

    void fitMCMC(int numSamples, int numBurnIn) {
        ParamUtils.isPositiveOrZero(numBurnIn, "Number of burn-in samples must be non-negative.");
        Utils.validateArg(numBurnIn < numSamples, "Number of samples must be greater than number of burn-in samples.");
        GibbsSampler<CopyRatioParameter, CopyRatioState, CopyRatioSegmentedData> gibbsSampler = new GibbsSampler<CopyRatioParameter, CopyRatioState, CopyRatioSegmentedData>(numSamples, this.model);
        gibbsSampler.runMCMC();
        this.varianceSamples.addAll(gibbsSampler.getSamples(CopyRatioParameter.VARIANCE, Double.class, numBurnIn));
        this.outlierProbabilitySamples.addAll(gibbsSampler.getSamples(CopyRatioParameter.OUTLIER_PROBABILITY, Double.class, numBurnIn));
        this.segmentMeansSamples.addAll(gibbsSampler.getSamples(CopyRatioParameter.SEGMENT_MEANS, CopyRatioState.SegmentMeans.class, numBurnIn));
    }

    List<Double> getVarianceSamples() {
        return Collections.unmodifiableList(this.varianceSamples);
    }

    List<Double> getOutlierProbabilitySamples() {
        return Collections.unmodifiableList(this.outlierProbabilitySamples);
    }

    List<CopyRatioState.SegmentMeans> getSegmentMeansSamples() {
        return Collections.unmodifiableList(this.segmentMeansSamples);
    }

    List<ModeledSegment.SimplePosteriorSummary> getSegmentMeansPosteriorSummaries() {
        if (this.segmentMeansSamples.isEmpty()) {
            throw new IllegalStateException("Attempted to get posterior summaries for segment means before MCMC was performed.");
        }
        int numSegments = this.segmentMeansSamples.get(0).size();
        ArrayList<ModeledSegment.SimplePosteriorSummary> posteriorSummaries = new ArrayList<ModeledSegment.SimplePosteriorSummary>(numSegments);
        int segmentIndex = 0;
        while (segmentIndex < numSegments) {
            int j = segmentIndex++;
            List<Double> meanSamples = this.segmentMeansSamples.stream().map(s -> (Double)s.get(j)).collect(Collectors.toList());
            posteriorSummaries.add(new ModeledSegment.SimplePosteriorSummary(meanSamples));
        }
        return posteriorSummaries;
    }

    ParameterDecileCollection<CopyRatioParameter> getGlobalParameterDeciles() {
        if (this.varianceSamples.isEmpty()) {
            throw new IllegalStateException("Attempted to get posterior summaries for global parameters before MCMC was performed.");
        }
        LinkedHashMap<CopyRatioParameter, DecileCollection> parameterToDecilesMap = new LinkedHashMap<CopyRatioParameter, DecileCollection>();
        parameterToDecilesMap.put(CopyRatioParameter.VARIANCE, new DecileCollection(this.varianceSamples));
        parameterToDecilesMap.put(CopyRatioParameter.OUTLIER_PROBABILITY, new DecileCollection(this.outlierProbabilitySamples));
        return new ParameterDecileCollection<CopyRatioParameter>(new SimpleSampleMetadata(this.metadata.getSampleName()), parameterToDecilesMap, CopyRatioParameter.class);
    }
}

