/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.models;

import com.google.common.primitives.Doubles;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.CopyRatioCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.SimpleIntervalCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CopyRatio;
import org.broadinstitute.hellbender.tools.copynumber.models.CopyRatioState;
import org.broadinstitute.hellbender.utils.IndexRange;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.mcmc.DataCollection;

final class CopyRatioSegmentedData
implements DataCollection {
    private final CopyRatioCollection copyRatios;
    private final SimpleIntervalCollection segments;
    private final double minLog2CopyRatioValue;
    private final double maxLog2CopyRatioValue;
    private final List<IndexedCopyRatio> indexedCopyRatios;
    private final List<IndexRange> indexRangesPerSegment;

    CopyRatioSegmentedData(CopyRatioCollection copyRatios, SimpleIntervalCollection segments) {
        this.copyRatios = Utils.nonNull(copyRatios);
        this.segments = Utils.nonNull(segments);
        List<Double> log2CopyRatioValues = copyRatios.getLog2CopyRatioValues();
        this.minLog2CopyRatioValue = log2CopyRatioValues.stream().min(Double::compareTo).orElse(Double.NaN);
        this.maxLog2CopyRatioValue = log2CopyRatioValues.stream().max(Double::compareTo).orElse(Double.NaN);
        ArrayList indexedCopyRatios = new ArrayList(copyRatios.size());
        ArrayList<IndexRange> indexRangesPerSegment = new ArrayList<IndexRange>(segments.size());
        OverlapDetector<CopyRatio> copyRatioMidpointOverlapDetector = copyRatios.getMidpointOverlapDetector();
        Comparator<Locatable> comparator = copyRatios.getComparator();
        int index = 0;
        int segmentIndex = 0;
        while (segmentIndex < segments.size()) {
            SimpleInterval segment = (SimpleInterval)segments.getRecords().get(segmentIndex);
            List copyRatiosInSegment = copyRatioMidpointOverlapDetector.getOverlaps((Locatable)segment).stream().sorted(comparator).collect(Collectors.toList());
            int segmentStartIndex = index;
            int si = segmentIndex++;
            IntStream.range(0, copyRatiosInSegment.size()).boxed().map(i -> new IndexedCopyRatio((CopyRatio)copyRatiosInSegment.get((int)i), segmentStartIndex + i, si)).forEach(indexedCopyRatios::add);
            indexRangesPerSegment.add(new IndexRange(segmentStartIndex, segmentStartIndex + copyRatiosInSegment.size()));
            index += copyRatiosInSegment.size();
        }
        this.indexedCopyRatios = Collections.unmodifiableList(indexedCopyRatios);
        this.indexRangesPerSegment = Collections.unmodifiableList(indexRangesPerSegment);
    }

    CopyRatioCollection getCopyRatios() {
        return this.copyRatios;
    }

    SimpleIntervalCollection getSegments() {
        return this.segments;
    }

    int getNumSegments() {
        return this.segments.size();
    }

    int getNumPoints() {
        return this.copyRatios.size();
    }

    double getMinLog2CopyRatioValue() {
        return this.minLog2CopyRatioValue;
    }

    double getMaxLog2CopyRatioValue() {
        return this.maxLog2CopyRatioValue;
    }

    List<IndexedCopyRatio> getIndexedCopyRatios() {
        return this.indexedCopyRatios;
    }

    List<IndexedCopyRatio> getIndexedCopyRatiosInSegment(int segmentIndex) {
        return this.indexedCopyRatios.subList(this.indexRangesPerSegment.get(segmentIndex).getStart(), this.indexRangesPerSegment.get(segmentIndex).getEnd());
    }

    double estimateVariance() {
        return IntStream.range(0, this.segments.size()).mapToDouble(s -> new Variance().evaluate(Doubles.toArray((Collection)this.getIndexedCopyRatiosInSegment(s).stream().map(CopyRatio::getLog2CopyRatioValue).collect(Collectors.toList())))).filter(v -> !Double.isNaN(v)).average().orElse(Double.NaN);
    }

    CopyRatioState.SegmentMeans estimateSegmentMeans() {
        List<Double> means = IntStream.range(0, this.segments.size()).boxed().map(s -> new Mean().evaluate(Doubles.toArray((Collection)this.getIndexedCopyRatiosInSegment((int)s).stream().map(CopyRatio::getLog2CopyRatioValue).collect(Collectors.toList())))).collect(Collectors.toList());
        return new CopyRatioState.SegmentMeans(means);
    }

    static final class IndexedCopyRatio
    extends CopyRatio {
        private final int index;
        private final int segmentIndex;

        private IndexedCopyRatio(CopyRatio copyRatio, int index, int segmentIndex) {
            super(copyRatio.getInterval(), copyRatio.getLog2CopyRatioValue());
            this.index = index;
            this.segmentIndex = segmentIndex;
        }

        int getIndex() {
            return this.index;
        }

        int getSegmentIndex() {
            return this.segmentIndex;
        }
    }
}

