/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.tools.copynumber.models.CopyRatioParameter;
import org.broadinstitute.hellbender.utils.mcmc.Parameter;
import org.broadinstitute.hellbender.utils.mcmc.ParameterizedState;

final class CopyRatioState
extends ParameterizedState<CopyRatioParameter> {
    CopyRatioState(double variance, double outlierProbability, SegmentMeans segmentMeans, OutlierIndicators outlierIndicators) {
        super(Arrays.asList(new Parameter<CopyRatioParameter, Double>(CopyRatioParameter.VARIANCE, variance), new Parameter<CopyRatioParameter, Double>(CopyRatioParameter.OUTLIER_PROBABILITY, outlierProbability), new Parameter<CopyRatioParameter, SegmentMeans>(CopyRatioParameter.SEGMENT_MEANS, segmentMeans), new Parameter<CopyRatioParameter, OutlierIndicators>(CopyRatioParameter.OUTLIER_INDICATORS, outlierIndicators)));
    }

    double variance() {
        return this.get(CopyRatioParameter.VARIANCE, Double.class);
    }

    double outlierProbability() {
        return this.get(CopyRatioParameter.OUTLIER_PROBABILITY, Double.class);
    }

    double segmentMean(int segmentIndex) {
        return (Double)this.get(CopyRatioParameter.SEGMENT_MEANS, SegmentMeans.class).get(segmentIndex);
    }

    boolean outlierIndicator(int copyRatioIndex) {
        return this.get(CopyRatioParameter.OUTLIER_INDICATORS, OutlierIndicators.class).get(copyRatioIndex);
    }

    static final class OutlierIndicators
    extends BitSet {
        private static final long serialVersionUID = 357159L;

        OutlierIndicators(List<Boolean> outlierIndicators) {
            super(outlierIndicators.size());
            IntStream.range(0, outlierIndicators.size()).filter(outlierIndicators::get).forEach(this::set);
        }
    }

    static final class SegmentMeans
    extends ArrayList<Double> {
        private static final long serialVersionUID = 951753L;

        SegmentMeans(List<Double> segmentMeans) {
            super(new ArrayList<Double>(segmentMeans));
        }
    }
}

