/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.plotting;

import htsjdk.samtools.SAMSequenceDictionary;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.cmdline.programgroups.CopyNumberProgramGroup;
import org.broadinstitute.hellbender.tools.copynumber.arguments.CopyNumberArgumentValidationUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.CopyRatioCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.plotting.PlottingUtils;
import org.broadinstitute.hellbender.utils.R.RScriptExecutor;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.Resource;
import org.broadinstitute.hellbender.utils.reference.ReferenceUtils;

@CommandLineProgramProperties(summary="Creates plots of denoised copy ratios", oneLineSummary="Creates plots of denoised copy ratios", programGroup=CopyNumberProgramGroup.class)
@DocumentedFeature
public final class PlotDenoisedCopyRatios
extends CommandLineProgram {
    private static final String PLOT_DENOISED_COPY_RATIOS_R_SCRIPT = "PlotDenoisedCopyRatios.R";
    @Argument(doc="Input file containing standardized copy ratios (output of DenoiseReadCounts).", fullName="standardized-copy-ratios")
    private File inputStandardizedCopyRatiosFile;
    @Argument(doc="Input file containing denoised copy ratios (output of DenoiseReadCounts).", fullName="denoised-copy-ratios")
    private File inputDenoisedCopyRatiosFile;
    @Argument(doc="File containing a sequence dictionary, which specifies the contigs to be plotted and their relative lengths. The sequence dictionary must be a subset of those contained in other input files. Contigs will be plotted in the order given. Contig names should not include the string \"CONTIG_DELIMITER\". The tool only considers contigs in the given dictionary for plotting, and data for contigs absent in the dictionary generate only a warning. In other words, you may modify a reference dictionary for use with this tool to include only contigs for which plotting is desired, and sort the contigs to the order in which the plots should display the contigs.", fullName="sequence-dictionary", shortName="sequence-dictionary")
    private File inputSequenceDictionaryFile;
    @Argument(doc="Threshold length (in bp) for contigs to be plotted. Contigs with lengths less than this threshold will not be plotted. This can be used to filter out mitochondrial contigs, unlocalized contigs, etc.", fullName="minimum-contig-length", minValue=0.0, optional=true)
    private int minContigLength = 1000000;
    @Argument(doc="Maximum copy ratio to be plotted. If Infinity, the maximum copy ratio will be automatically determined.", fullName="maximum-copy-ratio", minValue=0.0, optional=true)
    private double maxCopyRatio = 4.0;
    @Argument(doc="Point size to use for plotting copy-ratio points.", fullName="point-size-copy-ratio", minValue=0.0, optional=true)
    private double pointSizeCopyRatio = 0.2;
    @Argument(doc="Prefix for output filenames.", fullName="output-prefix")
    private String outputPrefix;
    @Argument(doc="Output directory.  This will be created if it does not exist.", fullName="output", shortName="O")
    private File outputDir;

    @Override
    protected Object doWork() {
        this.validateArguments();
        this.logger.info("Reading and validating input files...");
        CopyRatioCollection standardizedCopyRatios = new CopyRatioCollection(this.inputStandardizedCopyRatiosFile);
        CopyRatioCollection denoisedCopyRatios = new CopyRatioCollection(this.inputDenoisedCopyRatiosFile);
        Utils.validateArg(standardizedCopyRatios.getIntervals().equals(denoisedCopyRatios.getIntervals()), "Intervals in input files must be identical.");
        String sampleName = PlotDenoisedCopyRatios.getSampleName(standardizedCopyRatios, denoisedCopyRatios);
        SAMSequenceDictionary sequenceDictionary = ((SampleLocatableMetadata)standardizedCopyRatios.getMetadata()).getSequenceDictionary();
        SAMSequenceDictionary sequenceDictionaryToPlot = ReferenceUtils.loadFastaDictionary(this.inputSequenceDictionaryFile);
        PlottingUtils.validateSequenceDictionarySubset(sequenceDictionary, sequenceDictionaryToPlot);
        Map<String, Integer> contigLengthMap = PlottingUtils.getContigLengthMap(sequenceDictionaryToPlot, this.minContigLength, this.logger);
        PlottingUtils.validateContigs(contigLengthMap, standardizedCopyRatios, this.inputStandardizedCopyRatiosFile, this.logger);
        PlottingUtils.validateContigs(contigLengthMap, denoisedCopyRatios, this.inputDenoisedCopyRatiosFile, this.logger);
        this.logger.info(String.format("Writing plots to %s...", this.outputDir.getAbsolutePath()));
        ArrayList<String> contigNames = new ArrayList<String>(contigLengthMap.keySet());
        ArrayList<Integer> contigLengths = new ArrayList<Integer>(contigLengthMap.values());
        this.writeDenoisingPlots(sampleName, contigNames, contigLengths);
        this.logger.info(String.format("%s complete.", this.getClass().getSimpleName()));
        return null;
    }

    private void validateArguments() {
        CopyNumberArgumentValidationUtils.validateInputs(this.inputStandardizedCopyRatiosFile, this.inputDenoisedCopyRatiosFile, this.inputSequenceDictionaryFile);
        Utils.nonEmpty(this.outputPrefix);
        CopyNumberArgumentValidationUtils.validateAndPrepareOutputDirectories(this.outputDir);
    }

    private static String getSampleName(CopyRatioCollection standardizedCopyRatios, CopyRatioCollection denoisedCopyRatios) {
        Utils.validateArg(((SampleLocatableMetadata)standardizedCopyRatios.getMetadata()).equals(denoisedCopyRatios.getMetadata()), "Metadata in input files must be identical.");
        return ((SampleLocatableMetadata)standardizedCopyRatios.getMetadata()).getSampleName();
    }

    private void writeDenoisingPlots(String sampleName, List<String> contigNames, List<Integer> contigLengths) {
        String contigNamesArg = String.join((CharSequence)"CONTIG_DELIMITER", contigNames);
        String contigLengthsArg = contigLengths.stream().map(Object::toString).collect(Collectors.joining("CONTIG_DELIMITER"));
        String outputDirArg = CopyNumberArgumentValidationUtils.addTrailingSlashIfNecessary(CopyNumberArgumentValidationUtils.getCanonicalPath(this.outputDir));
        RScriptExecutor executor = new RScriptExecutor();
        executor.addScript(new Resource("CNVPlottingLibrary.R", PlotDenoisedCopyRatios.class));
        executor.addScript(new Resource(PLOT_DENOISED_COPY_RATIOS_R_SCRIPT, PlotDenoisedCopyRatios.class));
        executor.addArgs("--args", "--sample_name=" + sampleName, "--standardized_copy_ratios_file=" + CopyNumberArgumentValidationUtils.getCanonicalPath(this.inputStandardizedCopyRatiosFile), "--denoised_copy_ratios_file=" + CopyNumberArgumentValidationUtils.getCanonicalPath(this.inputDenoisedCopyRatiosFile), "--contig_names=" + contigNamesArg, "--contig_lengths=" + contigLengthsArg, "--maximum_copy_ratio=" + this.maxCopyRatio, "--point_size_copy_ratio=" + this.pointSizeCopyRatio, "--output_dir=" + outputDirArg, "--output_prefix=" + this.outputPrefix);
        executor.exec();
    }
}

