/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.util.Locatable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CopyNumberProgramGroup;
import org.broadinstitute.hellbender.engine.GATKTool;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedInterval;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedIntervalCollection;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SequenceDictionaryUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

@CommandLineProgramProperties(oneLineSummary="Combine the breakpoints of two segment files and annotate the resulting intervals with chosen columns from each file.", summary="Combine the breakpoints of two segment files while preserving annotations.\nThis tool will load all segments into RAM.\nComments lines start with '#' or the data can be prepended by a SAM File Header (not both).\nOutput file comments will be the first segment file comments concatenated with the second file comments.\nSAMFileHeaders in the input seg files are supported and will be merged in the output.\nOutput seg file will have a SAMFileHeader, even if the inputs did not.  If neither input file has a SAMFileHeader, then a reference must be specified.", programGroup=CopyNumberProgramGroup.class)
@ExperimentalFeature
public class CombineSegmentBreakpoints
extends GATKTool {
    private static final Logger logger = LogManager.getLogger(CombineSegmentBreakpoints.class);
    public static final String COLUMNS_OF_INTEREST_LONG_NAME = "columns-of-interest";
    public static final String LABELS_LONG_NAME = "labels";
    @Argument(doc="Input segment files -- must be specified twice, but order does not matter.", fullName="segments", maxElements=2, minElements=2)
    private List<File> segmentFiles = new ArrayList<File>();
    @Argument(doc="Input segment file labels -- these will appear as suffixes in case of collisions.  The specification order must correspond to the input segment files.", fullName="labels", maxElements=2, minElements=2, optional=true)
    private List<String> segmentFileLabels = Lists.newArrayList((Object[])new String[]{"1", "2"});
    @Argument(doc="List of columns in either segment file that should be reported in the output file.  If the column header exists in both, it will have the appropriate label appended as a suffix.", fullName="columns-of-interest", minElements=1)
    private Set<String> columnsOfInterest = new HashSet<String>();
    @Argument(doc="Output TSV file with combined segment breakpoints", shortName="O", fullName="output")
    private File outputFile;

    @Override
    public void traverse() {
        AnnotatedIntervalCollection annotatedIntervalCollection1 = AnnotatedIntervalCollection.create(this.segmentFiles.get(0).toPath(), this.columnsOfInterest);
        List<AnnotatedInterval> segments1 = annotatedIntervalCollection1.getRecords();
        AnnotatedIntervalCollection annotatedIntervalCollection2 = AnnotatedIntervalCollection.create(this.segmentFiles.get(1).toPath(), this.columnsOfInterest);
        List<AnnotatedInterval> segments2 = annotatedIntervalCollection2.getRecords();
        SAMFileHeader outputSamFileHeader = this.createOutputSamFileHeader(annotatedIntervalCollection1, annotatedIntervalCollection2);
        Sets.SetView allSeenAnnotations = Sets.union(new HashSet<String>(annotatedIntervalCollection1.getAnnotations()), new HashSet<String>(annotatedIntervalCollection2.getAnnotations()));
        Sets.SetView unusedColumnsOfInterest = Sets.difference(this.columnsOfInterest, (Set)allSeenAnnotations);
        if (unusedColumnsOfInterest.size() > 0) {
            ArrayList missingColumns = new ArrayList(unusedColumnsOfInterest);
            throw new UserException.BadInput("Some columns of interest specified by the user were not seen in any input files: " + StringUtils.join(missingColumns, (String)", "));
        }
        Sets.SetView intersectingAnnotations = Sets.intersection((Set)segments1.get(0).getAnnotations().keySet(), (Set)segments2.get(0).getAnnotations().keySet());
        Map input1ToOutputHeaderMap = segments1.get(0).getAnnotations().keySet().stream().filter(arg_0 -> CombineSegmentBreakpoints.lambda$traverse$0((Set)intersectingAnnotations, arg_0)).collect(Collectors.toMap(Function.identity(), Function.identity()));
        intersectingAnnotations.forEach(a -> input1ToOutputHeaderMap.put(a, a + "_" + this.segmentFileLabels.get(0)));
        Map input2ToOutputHeaderMap = segments2.get(0).getAnnotations().keySet().stream().filter(arg_0 -> CombineSegmentBreakpoints.lambda$traverse$2((Set)intersectingAnnotations, arg_0)).collect(Collectors.toMap(Function.identity(), Function.identity()));
        intersectingAnnotations.forEach(a -> input2ToOutputHeaderMap.put(a, a + "_" + this.segmentFileLabels.get(1)));
        List<AnnotatedInterval> finalList = this.annotateCombinedIntervals(segments1, segments2, Arrays.asList(input1ToOutputHeaderMap, input2ToOutputHeaderMap), outputSamFileHeader.getSequenceDictionary(), l -> this.progressMeter.update((Locatable)l));
        ArrayList finalAnnotations = Lists.newArrayList((Iterable)finalList.get(0).getAnnotations().keySet());
        finalAnnotations.sort(String::compareTo);
        AnnotatedIntervalCollection finalCollection = AnnotatedIntervalCollection.create(finalList, outputSamFileHeader, finalAnnotations);
        finalCollection.write(this.outputFile);
    }

    private SAMFileHeader createOutputSamFileHeader(AnnotatedIntervalCollection annotatedIntervalCollection1, AnnotatedIntervalCollection annotatedIntervalCollection2) {
        Utils.nonNull(annotatedIntervalCollection1);
        Utils.nonNull(annotatedIntervalCollection2);
        SAMFileHeader samFileHeader1 = annotatedIntervalCollection1.getSamFileHeader();
        SAMFileHeader samFileHeader2 = annotatedIntervalCollection2.getSamFileHeader();
        CombineSegmentBreakpoints.assertSequenceDictionaryCompatibility(samFileHeader1, samFileHeader2);
        this.warnIfOnlyOneSequenceDictionarySpecified(samFileHeader1, samFileHeader2);
        SamFileHeaderMerger samFileHeaderMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, Arrays.asList(samFileHeader1, samFileHeader2), true);
        SAMFileHeader outputSamFileHeader = samFileHeaderMerger.getMergedHeader();
        if (outputSamFileHeader.getSequenceDictionary().getReferenceLength() == 0L && this.getBestAvailableSequenceDictionary() == null) {
            throw new UserException.BadInput("Cannot assemble a reference dictionary.  In order to use this tool, one of the following conditions must be satisfied:  1)  One or both input files have a SAM File header ... 2)  A reference is provided (-R)");
        }
        if (outputSamFileHeader.getSequenceDictionary().getReferenceLength() == 0L) {
            outputSamFileHeader.setSequenceDictionary(this.getBestAvailableSequenceDictionary());
        }
        return outputSamFileHeader;
    }

    private void warnIfOnlyOneSequenceDictionarySpecified(SAMFileHeader samFileHeader1, SAMFileHeader samFileHeader2) {
        boolean isSamFileHeader2Empty;
        boolean isSamFileHeader1Empty = samFileHeader1.getSequenceDictionary().getReferenceLength() == 0L;
        boolean bl = isSamFileHeader2Empty = samFileHeader2.getSequenceDictionary().getReferenceLength() == 0L;
        if (isSamFileHeader1Empty ^ isSamFileHeader2Empty) {
            logger.warn("One of the input files does not have a SAMFileHeader with a sequence dictionary.  Assuming that the specified SAMFileHeader dictionary is applicable to both input collections.");
        }
    }

    private static void assertSequenceDictionaryCompatibility(SAMFileHeader samFileHeader1, SAMFileHeader samFileHeader2) {
        SequenceDictionaryUtils.SequenceDictionaryCompatibility compatibilityResult = SequenceDictionaryUtils.compareDictionaries(samFileHeader1.getSequenceDictionary(), samFileHeader2.getSequenceDictionary(), true);
        switch (compatibilityResult) {
            case UNEQUAL_COMMON_CONTIGS: {
                throw new UserException.BadInput("Input files had common contigs with different lengths in the sequence dictionaries.  Were these segment files generated with the same reference?");
            }
            case NON_CANONICAL_HUMAN_ORDER: {
                logger.warn("Input files contain sequence dictionaries from human reference, but the sorting is not canonical.  Downstream errors are possible.");
                return;
            }
            case OUT_OF_ORDER: {
                throw new UserException.BadInput("Input files have different sequence dictionary ordering.  The risk of errors downstream is too high to continue.");
            }
            case SUPERSET: 
            case COMMON_SUBSET: 
            case IDENTICAL: 
            case NO_COMMON_CONTIGS: 
            case DIFFERENT_INDICES: {
                return;
            }
        }
        logger.warn("Received an unrecognized compatibility result: " + compatibilityResult.toString() + ".  Continuing, but errors may result downstream.");
    }

    private List<AnnotatedInterval> annotateCombinedIntervals(List<AnnotatedInterval> segments1, List<AnnotatedInterval> segments2, List<Map<String, String>> inputToOutputHeaderMaps, SAMSequenceDictionary dictionary, Consumer<Locatable> progressUpdater) {
        List<List> segmentLists = Arrays.asList(segments1, segments2);
        List<Locatable> combinedIntervals = IntervalUtils.combineAndSortBreakpoints(segmentLists.get(0).stream().map(AnnotatedInterval::getInterval).collect(Collectors.toList()), segmentLists.get(1).stream().map(AnnotatedInterval::getInterval).collect(Collectors.toList()), dictionary);
        logger.info("Creating map of overlaps...");
        List combinedIntervalsToSegmentsMaps = segmentLists.stream().map(segs -> IntervalUtils.createOverlapMap(combinedIntervals, segs, dictionary)).collect(Collectors.toList());
        ArrayList<AnnotatedInterval> result = new ArrayList<AnnotatedInterval>();
        logger.info("Annotating...");
        for (Locatable interval : combinedIntervals) {
            TreeMap<String, String> intervalAnnotationMap = new TreeMap<String, String>();
            for (int i = 0; i < combinedIntervalsToSegmentsMaps.size(); ++i) {
                Map combinedIntervalsToSegmentsMap = (Map)combinedIntervalsToSegmentsMaps.get(i);
                Map<String, String> inputToOutputHeaderMap = inputToOutputHeaderMaps.get(i);
                List matchingSegments = (List)combinedIntervalsToSegmentsMap.get(interval);
                inputToOutputHeaderMap.forEach((k, v) -> {
                    if (matchingSegments.size() > 1) {
                        logger.warn(interval + " had more than one segment: " + matchingSegments + " only annotating with the first match.");
                    }
                    if (matchingSegments.size() >= 1) {
                        intervalAnnotationMap.put((String)v, ((AnnotatedInterval)matchingSegments.get(0)).getAnnotationValueOrDefault((String)k, ""));
                    } else {
                        intervalAnnotationMap.put((String)v, "");
                    }
                });
            }
            result.add(new AnnotatedInterval(new SimpleInterval(interval), intervalAnnotationMap));
            progressUpdater.accept(interval);
        }
        return result;
    }

    private static /* synthetic */ boolean lambda$traverse$2(Set intersectingAnnotations, String a) {
        return !intersectingAnnotations.contains(a);
    }

    private static /* synthetic */ boolean lambda$traverse$0(Set intersectingAnnotations, String a) {
        return !intersectingAnnotations.contains(a);
    }
}

