/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.utils;

import htsjdk.samtools.util.Locatable;
import java.io.File;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CopyNumberProgramGroup;
import org.broadinstitute.hellbender.engine.GATKTool;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedInterval;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedIntervalCollection;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedIntervalUtils;
import org.broadinstitute.hellbender.utils.IntervalUtils;

@CommandLineProgramProperties(oneLineSummary="Merge annotated genomic regions based entirely on touching/overlapping intervals.", summary="Merge annotated genomic regions based entirely on contig and annotation value.  Column header order is not guaranteed to be preserved. Reference is required and will superseded any sequence dictionary in the given seg/region files.  Sequence dictionary is optional on the input file, but will be included on the output.  Conflicts of annotations is resolved by sorting the values and inserting a delimiter.  THIS TOOL IS TOTALLY UNSUPPORTED", programGroup=CopyNumberProgramGroup.class)
@ExperimentalFeature
public class MergeAnnotatedRegions
extends GATKTool {
    @Argument(doc="Input segment file or annotated segment file -- touching segments will be merged in the output.", fullName="segments")
    private File segmentFile;
    @Argument(doc="Output TSV file", shortName="O", fullName="output")
    private File outputFile;
    static final String DEFAULT_SEPARATOR = "__";

    @Override
    public void traverse() {
        AnnotatedIntervalCollection annotatedIntervalCollection = AnnotatedIntervalCollection.create(this.segmentFile.toPath(), null);
        List<AnnotatedInterval> initialSegments = annotatedIntervalCollection.getRecords();
        List<AnnotatedInterval> segments = IntervalUtils.sortLocatablesBySequenceDictionary(initialSegments, this.getBestAvailableSequenceDictionary());
        List<AnnotatedInterval> finalSegments = AnnotatedIntervalUtils.mergeRegions(segments, this.getBestAvailableSequenceDictionary(), DEFAULT_SEPARATOR, l -> this.progressMeter.update((Locatable)l));
        AnnotatedIntervalCollection collection = AnnotatedIntervalCollection.create(finalSegments, annotatedIntervalCollection.getSamFileHeader(), annotatedIntervalCollection.getAnnotations());
        collection.write(this.outputFile);
    }
}

