/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.utils;

import com.google.common.collect.Sets;
import htsjdk.samtools.util.Locatable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CopyNumberProgramGroup;
import org.broadinstitute.hellbender.engine.GATKTool;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedInterval;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedIntervalCollection;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedIntervalHeader;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedIntervalUtils;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.SimpleAnnotatedIntervalWriter;
import org.broadinstitute.hellbender.utils.Utils;

@CommandLineProgramProperties(oneLineSummary="Merge annotated genomic regions within specified distance if annotation value(s) are exactly the same.", summary="This simple tool will merge genomic regions (specified in a tsv) when given annotations (columns) contain exact values in neighboring segments and the segments are within a specified maximum genomic distance.", programGroup=CopyNumberProgramGroup.class)
@ExperimentalFeature
public class MergeAnnotatedRegionsByAnnotation
extends GATKTool {
    public static final String ANNOTATIONS_TO_MATCH = "annotations-to-match";
    public static final String MAX_MERGE_DISTANCE = "max-merge-distance";
    @Argument(doc="Input segment file or annotated segment file.", fullName="segments")
    private File segmentFile;
    @Argument(doc="Annotation(s) to merge on.", fullName="annotations-to-match")
    private List<String> annotationsToMatch;
    @Argument(doc="Maximum distance to merge in bases", fullName="max-merge-distance", optional=true)
    private Integer maxMergeDistance = 1000000;
    @Argument(doc="Output TSV file", shortName="O", fullName="output")
    private File outputFile;
    static final String DEFAULT_SEPARATOR = "__";
    @Argument(doc="Output contig column name.", fullName="output-contig-column", optional=true)
    private String outputContigColumn = "CONTIG";
    @Argument(doc="Output start position column name.", fullName="output-start-column", optional=true)
    private String outputStartColumn = "START";
    @Argument(doc="Output end column name.", fullName="output-end-column", optional=true)
    private String outputEndColumn = "END";

    @Override
    public void traverse() {
        AnnotatedIntervalCollection annotatedIntervalCollection = AnnotatedIntervalCollection.create(this.segmentFile.toPath(), null);
        List<AnnotatedInterval> initialSegments = annotatedIntervalCollection.getRecords();
        Utils.validateArg(annotatedIntervalCollection.getAnnotations().containsAll(this.annotationsToMatch), "Input file did not have all of the specified annotations.  Missing annotations were: " + Sets.difference(new HashSet<String>(this.annotationsToMatch), new HashSet<String>(annotatedIntervalCollection.getAnnotations())).stream().collect(Collectors.joining(", ")));
        Utils.validateArg(this.getBestAvailableSequenceDictionary() != null, "Sequence dictionary not available in the input file nor specified in a reference parameter.  Please specify a reference with the -R parameter for this input file.");
        List<AnnotatedInterval> mergedSegments = AnnotatedIntervalUtils.mergeRegionsByAnnotation(initialSegments, this.getBestAvailableSequenceDictionary(), this.annotationsToMatch, l -> this.progressMeter.update((Locatable)l), DEFAULT_SEPARATOR, this.maxMergeDistance);
        AnnotatedIntervalHeader header = new AnnotatedIntervalHeader(this.outputContigColumn, this.outputStartColumn, this.outputEndColumn, new ArrayList<String>((Collection<String>)mergedSegments.get(0).getAnnotations().keySet()), null);
        SimpleAnnotatedIntervalWriter writer = new SimpleAnnotatedIntervalWriter(this.outputFile);
        writer.writeHeader(header);
        mergedSegments.forEach(s -> writer.add((AnnotatedInterval)s));
        writer.close();
    }
}

