/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.utils;

import java.io.File;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CopyNumberProgramGroup;
import org.broadinstitute.hellbender.engine.GATKTool;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedInterval;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedIntervalCollection;
import org.broadinstitute.hellbender.tools.copynumber.utils.germlinetagging.SimpleGermlineTagger;

@CommandLineProgramProperties(oneLineSummary="Do a simplistic tagging of germline events in a tumor segment file.", summary="A tool for tagging possible germline events in a tumor segment file.  The algorithm used is very simplistic.  Segments called as amplified or deleted in the normal are matched by breakpoints (+/- some padding) or reciprocal overlap.", programGroup=CopyNumberProgramGroup.class)
@ExperimentalFeature
public class TagGermlineEvents
extends GATKTool {
    public static final String MATCHED_NORMAL_SEGMENT_FILE_LONG_NAME = "called-matched-normal-seg-file";
    public static final int DEFAULT_GERMLINE_TAG_PADDING_IN_BP = 1000;
    public static final String PADDING_IN_BP_LONG_NAME = "endpoint-padding";
    public static final String GERMLINE_TAG_HEADER = "POSSIBLE_GERMLINE";
    public static final String INPUT_CALL_HEADER = "input-call-header";
    @Argument(doc="Input tumor (called) segment file -- the output will be a copy of this file with the additional information.", fullName="segments", shortName="S")
    private File tumorSegmentFile;
    @Argument(doc="Matched normal called segment file.", fullName="called-matched-normal-seg-file")
    private File calledNormalSegmentFile;
    @Argument(doc="Output TSV file identical to the tumor segment file, but with additional germline tag column (POSSIBLE_GERMLINE).", fullName="output", shortName="O")
    private File outputFile;
    @Argument(doc="Amount of padding, in bases, to allow a breakpoint match.", fullName="endpoint-padding")
    private int paddingInBp = 1000;
    @Argument(doc="Column header to use for the call (amplified, neutral, or deleted).", fullName="input-call-header", optional=true)
    private String callColumnHeader = "CALL";
    @Argument(doc="Reciprocal threshold to match a segment (when endpoints do not match).  Over this threshold will cause a tumor segment to be tagged.", fullName="reciprocal-threshold", optional=true)
    private double reciprocalThreshold = 0.75;

    @Override
    public void traverse() {
        AnnotatedIntervalCollection tumorAnnotatedIntervalCollection = AnnotatedIntervalCollection.create(this.tumorSegmentFile.toPath(), null);
        List<AnnotatedInterval> initialTumorSegments = tumorAnnotatedIntervalCollection.getRecords();
        List<AnnotatedInterval> initialNormalSegments = AnnotatedIntervalCollection.create(this.calledNormalSegmentFile.toPath(), null).getRecords();
        List<AnnotatedInterval> tumorSegments = SimpleGermlineTagger.tagTumorSegmentsWithGermlineActivity(initialTumorSegments, initialNormalSegments, this.callColumnHeader, this.getBestAvailableSequenceDictionary(), GERMLINE_TAG_HEADER, this.paddingInBp, this.reciprocalThreshold);
        List<String> finalAnnotations = tumorAnnotatedIntervalCollection.getAnnotations();
        finalAnnotations.add(GERMLINE_TAG_HEADER);
        finalAnnotations.sort(String::compareTo);
        AnnotatedIntervalCollection finalCollection = AnnotatedIntervalCollection.create(tumorSegments, tumorAnnotatedIntervalCollection.getSamFileHeader(), finalAnnotations);
        finalCollection.write(this.outputFile);
    }

    @Override
    public boolean requiresReference() {
        return true;
    }
}

