/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval;

import com.google.common.collect.ImmutableSortedMap;
import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.Feature;
import java.util.SortedMap;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public final class AnnotatedInterval
implements Locatable,
Feature {
    private final SimpleInterval interval;
    private final SortedMap<String, String> annotations;

    public AnnotatedInterval(SimpleInterval interval, SortedMap<String, String> annotations) {
        this.interval = interval;
        this.annotations = annotations;
    }

    public SimpleInterval getInterval() {
        return new SimpleInterval(this.interval);
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public String getAnnotationValue(String annotationName) {
        return (String)this.annotations.get(annotationName);
    }

    public String getAnnotationValueOrDefault(String annotationName, String defaultValue) {
        return this.annotations.getOrDefault(annotationName, defaultValue);
    }

    public ImmutableSortedMap<String, String> getAnnotations() {
        return ImmutableSortedMap.copyOfSorted(this.annotations);
    }

    public boolean hasAnnotation(String annotationName) {
        return this.annotations.containsKey(annotationName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotatedInterval that = (AnnotatedInterval)o;
        return this.interval.equals(that.getInterval()) && this.getAnnotations().equals(that.getAnnotations());
    }

    public int hashCode() {
        int result = this.interval.hashCode();
        result = 31 * result + this.annotations.hashCode();
        return result;
    }

    public String toString() {
        return "AnnotatedInterval{interval=" + this.interval + ", annotations=" + this.annotations + '}';
    }
}

