/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.FeatureCodec;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedInterval;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedIntervalHeader;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.SimpleAnnotatedIntervalWriter;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.codecs.AnnotatedIntervalCodec;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.io.Resource;

public class AnnotatedIntervalCollection {
    private static final Logger logger = LogManager.getLogger(AnnotatedIntervalCollection.class);
    private final SAMFileHeader samFileHeader;
    private final List<String> annotations;
    private final List<AnnotatedInterval> records;

    private AnnotatedIntervalCollection(SAMFileHeader samFileHeader, List<String> annotations, List<AnnotatedInterval> records) {
        this.samFileHeader = samFileHeader;
        this.annotations = annotations;
        this.annotations.sort(String::compareTo);
        this.records = records;
    }

    public static AnnotatedIntervalCollection create(List<AnnotatedInterval> regions, SAMFileHeader samFileHeader, List<String> annotations) {
        Utils.nonNull(regions);
        Utils.nonNull(annotations);
        ImmutableSortedSet regionAnnotations = regions.get(0).getAnnotations().keySet();
        if (regions.stream().anyMatch(arg_0 -> AnnotatedIntervalCollection.lambda$create$0((Set)regionAnnotations, arg_0))) {
            throw new GATKException.ShouldNeverReachHereException("Tried to create an AnnotatedIntervalCollection with inconsistent region annotations.");
        }
        List<AnnotatedInterval> updatedAnnotatedIntervals = regions.stream().map(r -> AnnotatedIntervalCollection.copyAnnotatedInterval(r, new HashSet<String>(annotations))).collect(Collectors.toList());
        return new AnnotatedIntervalCollection(samFileHeader, annotations, updatedAnnotatedIntervals);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AnnotatedIntervalCollection create(Path input, Path inputConfigFile, Set<String> headersOfInterest) {
        IOUtils.assertFileIsReadable(input);
        IOUtils.assertFileIsReadable(inputConfigFile);
        AnnotatedIntervalCodec codec = new AnnotatedIntervalCodec(inputConfigFile);
        ArrayList<AnnotatedInterval> regions = new ArrayList<AnnotatedInterval>();
        if (!codec.canDecode(input.toUri().toString())) throw new UserException.BadInput("Could not parse xsv file: " + input.toUri().toString());
        try (AbstractFeatureReader reader = AbstractFeatureReader.getFeatureReader((String)input.toUri().toString(), (FeatureCodec)codec, (boolean)false);){
            AnnotatedIntervalHeader header = (AnnotatedIntervalHeader)reader.getHeader();
            List<String> finalAnnotations = AnnotatedIntervalCollection.determineCollectionAnnotations(headersOfInterest, header.getAnnotations());
            CloseableTribbleIterator it = reader.iterator();
            StreamSupport.stream(it.spliterator(), false).filter(r -> r != null).map(r -> AnnotatedIntervalCollection.copyAnnotatedInterval(r, new HashSet<String>(finalAnnotations))).forEach(r -> regions.add((AnnotatedInterval)r));
            AnnotatedIntervalCollection annotatedIntervalCollection = new AnnotatedIntervalCollection(header.getSamFileHeader(), finalAnnotations, regions);
            return annotatedIntervalCollection;
        }
        catch (IOException ex) {
            throw new GATKException("Error - IO problem with file " + input, ex);
        }
    }

    public static AnnotatedIntervalCollection create(Path input, Set<String> headersOfInterest) {
        String resourcePath = "org/broadinstitute/hellbender/tools/copynumber/utils/annotatedinterval/annotated_region_default.config";
        try {
            File tmpResourceFile = Resource.getResourceContentsAsFile("org/broadinstitute/hellbender/tools/copynumber/utils/annotatedinterval/annotated_region_default.config");
            return AnnotatedIntervalCollection.create(input, tmpResourceFile.toPath(), headersOfInterest);
        }
        catch (IOException ioe) {
            throw new GATKException.ShouldNeverReachHereException("Could not read config file: org/broadinstitute/hellbender/tools/copynumber/utils/annotatedinterval/annotated_region_default.config", ioe);
        }
    }

    private static List<String> determineCollectionAnnotations(Set<String> headersOfInterest, List<String> actualAnnotations) throws IOException {
        AnnotatedIntervalCollection.warnAllHeadersOfInterestNotPresent(headersOfInterest, actualAnnotations);
        if (headersOfInterest == null) {
            return actualAnnotations;
        }
        return headersOfInterest.stream().sorted().filter(h -> actualAnnotations.contains(h)).collect(Collectors.toList());
    }

    private static void warnAllHeadersOfInterestNotPresent(Set<String> headersOfInterest, List<String> header) {
        Sets.SetView unusedColumnsOfInterest;
        if (headersOfInterest != null && !header.containsAll(headersOfInterest) && (unusedColumnsOfInterest = Sets.difference(new HashSet<String>(headersOfInterest), new HashSet<String>(header))).size() > 0) {
            ArrayList missingColumns = new ArrayList(unusedColumnsOfInterest);
            logger.warn("Some headers of interest specified by the user were not seen in input: " + StringUtils.join(missingColumns, (String)", "));
        }
    }

    @VisibleForTesting
    static AnnotatedInterval copyAnnotatedInterval(AnnotatedInterval annotatedInterval, Set<String> annotationsToPreserve) {
        Utils.nonNull(annotatedInterval);
        Utils.nonNull(annotationsToPreserve);
        SortedMap copiedAnnotations = annotatedInterval.getAnnotations().entrySet().stream().filter(e -> annotationsToPreserve.contains(e.getKey())).collect(TreeMap::new, (map, e) -> {
            String cfr_ignored_0 = (String)map.put(e.getKey(), e.getValue());
        }, (map, map2) -> map.putAll(map2));
        return new AnnotatedInterval(annotatedInterval.getInterval(), copiedAnnotations);
    }

    public void write(File outputFile) {
        Utils.nonNull(outputFile);
        SimpleAnnotatedIntervalWriter writer = new SimpleAnnotatedIntervalWriter(outputFile);
        writer.writeHeader(AnnotatedIntervalCodec.createHeaderForWriter(this.annotations, this.samFileHeader));
        this.getRecords().forEach(writer::add);
        writer.close();
    }

    public SAMFileHeader getSamFileHeader() {
        return this.samFileHeader;
    }

    public List<String> getComments() {
        if (this.getSamFileHeader() == null) {
            return Collections.emptyList();
        }
        return this.getSamFileHeader().getComments().stream().map(c -> c.replaceFirst(SAMTextHeaderCodec.COMMENT_PREFIX, "")).collect(Collectors.toList());
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public List<AnnotatedInterval> getRecords() {
        return this.records;
    }

    public int size() {
        return this.getRecords().size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotatedIntervalCollection that = (AnnotatedIntervalCollection)o;
        return this.samFileHeader.equals((Object)that.samFileHeader) && this.records.equals(that.records) && this.annotations.equals(that.annotations);
    }

    public int hashCode() {
        int result = this.samFileHeader.hashCode();
        result = 31 * result + this.records.hashCode();
        result = 31 * result + this.annotations.hashCode();
        return result;
    }

    public String toString() {
        return "AnnotatedIntervalCollection{samFileHeader=" + this.samFileHeader + ", annotations=" + this.annotations + ", records=" + this.records + '}';
    }

    private static /* synthetic */ boolean lambda$create$0(Set regionAnnotations, AnnotatedInterval r) {
        return !r.getAnnotations().keySet().equals((Object)regionAnnotations);
    }
}

