/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval;

import com.google.common.collect.Sets;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.PeekableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedInterval;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public class AnnotatedIntervalUtils {
    private AnnotatedIntervalUtils() {
    }

    public static List<AnnotatedInterval> mergeRegions(List<AnnotatedInterval> initialRegions, SAMSequenceDictionary dictionary, String annotationSeparator, Consumer<Locatable> progressUpdater) {
        Utils.nonNull(initialRegions);
        Utils.nonNull(dictionary);
        Utils.nonNull(annotationSeparator);
        Utils.nonNull(progressUpdater);
        List<AnnotatedInterval> segments = IntervalUtils.sortLocatablesBySequenceDictionary(initialRegions, dictionary);
        ArrayList<AnnotatedInterval> finalSegments = new ArrayList<AnnotatedInterval>();
        PeekableIterator segmentsIterator = new PeekableIterator(segments.iterator());
        while (segmentsIterator.hasNext()) {
            AnnotatedInterval currentRegion = (AnnotatedInterval)segmentsIterator.next();
            while (segmentsIterator.peek() != null && IntervalUtils.overlaps(currentRegion, (Locatable)segmentsIterator.peek())) {
                AnnotatedInterval toBeMerged = (AnnotatedInterval)segmentsIterator.next();
                currentRegion = AnnotatedIntervalUtils.merge(currentRegion, toBeMerged, annotationSeparator);
            }
            progressUpdater.accept(currentRegion);
            finalSegments.add(currentRegion);
        }
        return finalSegments;
    }

    private static AnnotatedInterval merge(AnnotatedInterval region1, AnnotatedInterval region2, String separator) {
        SimpleInterval interval = AnnotatedIntervalUtils.mergeIntervals(region1.getInterval(), region2.getInterval());
        Sets.SetView allEntries = Sets.union((Set)region1.getAnnotations().entrySet(), (Set)region2.getAnnotations().entrySet());
        BiFunction<String, String, String> conflictFunction = (s1, s2) -> AnnotatedIntervalUtils.renderConflict(s1, s2, separator);
        TreeMap<String, String> annotations = new TreeMap<String, String>();
        allEntries.forEach(e -> annotations.put((String)e.getKey(), AnnotatedIntervalUtils.mergeAnnotationValue((String)e.getKey(), region1, region2, conflictFunction)));
        return new AnnotatedInterval(interval, annotations);
    }

    public static List<AnnotatedInterval> mergeRegionsByAnnotation(List<AnnotatedInterval> initialRegions, SAMSequenceDictionary dictionary, List<String> annotationNames, Consumer<Locatable> progressUpdater, String annotationSeparator, int maxDistanceInBp) {
        Utils.nonNull(initialRegions);
        Utils.nonNull(dictionary);
        Utils.nonNull(annotationNames);
        Utils.nonNull(annotationSeparator);
        Utils.nonNull(progressUpdater);
        ParamUtils.isPositiveOrZero(maxDistanceInBp, "Cannot have a negative value for distance.");
        List<AnnotatedInterval> segments = IntervalUtils.sortLocatablesBySequenceDictionary(initialRegions, dictionary);
        ArrayList<AnnotatedInterval> finalSegments = new ArrayList<AnnotatedInterval>();
        PeekableIterator segmentsIterator = new PeekableIterator(segments.iterator());
        while (segmentsIterator.hasNext()) {
            AnnotatedInterval currentRegion = (AnnotatedInterval)segmentsIterator.next();
            while (segmentsIterator.peek() != null && AnnotatedIntervalUtils.isMergeByAnnotation(currentRegion, (AnnotatedInterval)segmentsIterator.peek(), maxDistanceInBp, annotationNames)) {
                AnnotatedInterval toBeMerged = (AnnotatedInterval)segmentsIterator.next();
                currentRegion = AnnotatedIntervalUtils.merge(currentRegion, toBeMerged, annotationSeparator);
            }
            progressUpdater.accept(currentRegion);
            finalSegments.add(currentRegion);
        }
        return finalSegments;
    }

    private static boolean isMergeByAnnotation(AnnotatedInterval interval1, AnnotatedInterval interval2, int maxDistance, List<String> annotationNames) {
        return interval1.getContig().equals(interval2.getContig()) && AnnotatedIntervalUtils.getDistance(interval1, interval2) <= (long)maxDistance && annotationNames.stream().allMatch(a -> interval1.getAnnotationValue((String)a).equals(interval2.getAnnotationValue((String)a)));
    }

    private static long getDistance(Locatable loc1, Locatable loc2) {
        Utils.nonNull(loc1);
        Utils.nonNull(loc2);
        if (!loc1.getContig().equals(loc2.getContig())) {
            return Long.MAX_VALUE;
        }
        if (IntervalUtils.overlaps(loc1, loc2)) {
            return 0L;
        }
        return loc1.getEnd() < loc2.getStart() ? (long)(loc2.getStart() - loc1.getEnd()) : (long)(loc1.getStart() - loc2.getEnd());
    }

    private static String mergeAnnotationValue(String annotationName, AnnotatedInterval region1, AnnotatedInterval region2, BiFunction<String, String, String> conflictFunction) {
        boolean doesRegion1ContainAnnotation = region1.hasAnnotation(annotationName);
        boolean doesRegion2ContainAnnotation = region2.hasAnnotation(annotationName);
        if (doesRegion1ContainAnnotation && doesRegion2ContainAnnotation) {
            return conflictFunction.apply(region1.getAnnotationValue(annotationName), region2.getAnnotationValue(annotationName));
        }
        if (doesRegion1ContainAnnotation) {
            return region1.getAnnotationValue(annotationName);
        }
        if (doesRegion2ContainAnnotation) {
            return region2.getAnnotationValue(annotationName);
        }
        return null;
    }

    private static String renderConflict(String s1, String s2, String separator) {
        String[] s1Vals = StringUtils.splitByWholeSeparator((String)s1, (String)separator);
        String[] s2Vals = StringUtils.splitByWholeSeparator((String)s2, (String)separator);
        HashSet<String> allValsSet = new HashSet<String>(Arrays.asList(s1Vals));
        allValsSet.addAll(Arrays.asList(s2Vals));
        ArrayList<String> allVals = new ArrayList<String>(allValsSet);
        allVals.sort(String::compareTo);
        return Utils.join(separator, allVals);
    }

    private static SimpleInterval mergeIntervals(SimpleInterval segment1, SimpleInterval segment2) {
        Utils.validateArg(segment1.getContig().equals(segment2.getContig()), () -> String.format("Cannot join segments %s and %s on different chromosomes.", segment1.toString(), segment2.toString()));
        int start = Math.min(segment1.getStart(), segment2.getStart());
        int end = Math.max(segment1.getEnd(), segment2.getEnd());
        return new SimpleInterval(segment1.getContig(), start, end);
    }
}

