/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval;

import com.google.common.collect.Lists;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.utils.Utils;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedInterval;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedIntervalHeader;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedIntervalWriter;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public class SimpleAnnotatedIntervalWriter
implements AnnotatedIntervalWriter {
    private SimpleTableWriter writer;
    private FileWriter fileWriter;
    private String contigColumnHeader;
    private String startColumnHeader;
    private String endColumnHeader;
    private File outputFile;
    private boolean hasHeaderBeenWritten = false;
    private static final Logger logger = LogManager.getLogger(SimpleAnnotatedIntervalWriter.class);

    public SimpleAnnotatedIntervalWriter(File outputFile) {
        IOUtil.assertFileIsWritable((File)outputFile);
        this.outputFile = outputFile;
    }

    private void initializeForWriting(String contigColumnName, String startColumnName, String endColumnName, List<String> annotations) {
        ArrayList finalColumnList = Lists.newArrayList((Object[])new String[]{contigColumnName, startColumnName, endColumnName});
        finalColumnList.addAll(annotations);
        try {
            this.fileWriter = new FileWriter(this.outputFile);
            this.writer = new SimpleTableWriter(this.fileWriter, new TableColumnCollection(finalColumnList));
        }
        catch (IOException ioe) {
            throw new GATKException("Could not create: " + this.outputFile.getAbsolutePath(), ioe);
        }
        this.contigColumnHeader = contigColumnName;
        this.startColumnHeader = startColumnName;
        this.endColumnHeader = endColumnName;
    }

    @Override
    public void writeHeader(AnnotatedIntervalHeader annotatedIntervalHeader) {
        Utils.nonNull((Object)annotatedIntervalHeader);
        if (!this.hasHeaderBeenWritten) {
            String contigColumnName = annotatedIntervalHeader.getContigColumnName();
            String startColumnName = annotatedIntervalHeader.getStartColumnName();
            String endColumnName = annotatedIntervalHeader.getEndColumnName();
            this.initializeForWriting(contigColumnName, startColumnName, endColumnName, annotatedIntervalHeader.getAnnotations());
            try {
                SAMFileHeader samFileHeader = annotatedIntervalHeader.getSamFileHeader();
                if (samFileHeader != null) {
                    this.fileWriter.write(samFileHeader.getSAMString());
                }
                this.writer.writeHeaderIfApplies();
                this.hasHeaderBeenWritten = true;
            }
            catch (IOException e) {
                throw new UserException.CouldNotCreateOutputFile("Could not write to file.", (Exception)e);
            }
        } else {
            logger.warn("Attempted to write header more than once.  Ignoring this request.");
        }
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile("Could not close file writing.", (Exception)e);
        }
    }

    @Override
    public void add(AnnotatedInterval annotatedInterval) {
        if (!this.hasHeaderBeenWritten) {
            throw new GATKException.ShouldNeverReachHereException("This is an invalid code path, since the header of the output file should already be written.  Please post this error to the GATK forum (https://gatkforums.broadinstitute.org/gatk)");
        }
        try {
            this.writer.writeRecord(annotatedInterval);
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile("Could not write to file.", (Exception)e);
        }
    }

    private class SimpleTableWriter
    extends TableWriter<AnnotatedInterval> {
        SimpleTableWriter(Writer writer, TableColumnCollection tableColumns) throws IOException {
            super(writer, tableColumns);
        }

        @Override
        protected void composeLine(AnnotatedInterval record, DataLine dataLine) {
            dataLine.set(SimpleAnnotatedIntervalWriter.this.contigColumnHeader, record.getContig());
            dataLine.set(SimpleAnnotatedIntervalWriter.this.startColumnHeader, record.getStart());
            dataLine.set(SimpleAnnotatedIntervalWriter.this.endColumnHeader, record.getEnd());
            record.getAnnotations().keySet().forEach(k -> dataLine.set((String)k, record.getAnnotationValue((String)k)));
        }
    }
}

