/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.utils.germlinetagging;

import com.google.common.collect.ImmutableSortedMap;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.PeekableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CalledCopyRatioSegment;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedInterval;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public class SimpleGermlineTagger {
    private SimpleGermlineTagger() {
    }

    public static List<AnnotatedInterval> tagTumorSegmentsWithGermlineActivity(List<AnnotatedInterval> initialTumorSegments, List<AnnotatedInterval> initialNormalSegments, String callAnnotation, SAMSequenceDictionary dictionary, String outputAnnotationName, int paddingInBp, double reciprocalThreshold) {
        Utils.nonNull(dictionary);
        Utils.nonNull(initialTumorSegments);
        Utils.nonNull(initialNormalSegments);
        Utils.nonNull(callAnnotation);
        IntervalUtils.validateNoOverlappingIntervals(initialTumorSegments);
        IntervalUtils.validateNoOverlappingIntervals(initialNormalSegments);
        ParamUtils.isPositiveOrZero(paddingInBp, "padding must be greater than or equal to zero.");
        ParamUtils.inRange(reciprocalThreshold, 0.0, 1.0, "Reciprocal threshold must be between 0.0 and 1.0");
        List<AnnotatedInterval> tumorSegments = IntervalUtils.sortLocatablesBySequenceDictionary(initialTumorSegments, dictionary);
        List<AnnotatedInterval> normalSegments = IntervalUtils.sortLocatablesBySequenceDictionary(initialNormalSegments, dictionary);
        Utils.validateArg(!StringUtils.isEmpty((CharSequence)outputAnnotationName), "Output annotation name cannot be empty.");
        Utils.validateArg(normalSegments.stream().noneMatch(s -> StringUtils.isEmpty((CharSequence)s.getAnnotationValue(callAnnotation))), "All normal segments must have a call.  Call annotation (column header) name must be: " + callAnnotation);
        Utils.validateArg(tumorSegments.stream().noneMatch(s -> StringUtils.isEmpty((CharSequence)s.getAnnotationValue(callAnnotation))), "All tumor segments must have a call.  Call annotation (column header) must be: " + callAnnotation);
        List<AnnotatedInterval> mergedNormalSegments = SimpleGermlineTagger.mergedRegionsByAnnotation(callAnnotation, normalSegments);
        List nonZeroMergedNormalSegments = mergedNormalSegments.stream().filter(s -> !StringUtils.isEmpty((CharSequence)s.getAnnotationValue(callAnnotation))).filter(s -> !s.getAnnotationValue(callAnnotation).equals(CalledCopyRatioSegment.Call.NEUTRAL.getOutputString())).collect(Collectors.toList());
        Map<AnnotatedInterval, List<AnnotatedInterval>> nonZeroMergedNormalSegmentsToTumorSegments = IntervalUtils.createOverlapMap(nonZeroMergedNormalSegments, tumorSegments, dictionary);
        Map<AnnotatedInterval, CalledCopyRatioSegment.Call> tumorSegsToGermlineTag = SimpleGermlineTagger.createTumorSegmentsToGermlineTagMap(nonZeroMergedNormalSegmentsToTumorSegments, paddingInBp, callAnnotation, reciprocalThreshold);
        return tumorSegments.stream().map(s -> SimpleGermlineTagger.createTumorTaggedSegment(s, outputAnnotationName, tumorSegsToGermlineTag.getOrDefault(s, CalledCopyRatioSegment.Call.NEUTRAL).getOutputString())).collect(Collectors.toList());
    }

    private static Map<AnnotatedInterval, CalledCopyRatioSegment.Call> createTumorSegmentsToGermlineTagMap(Map<AnnotatedInterval, List<AnnotatedInterval>> nonZeroMergedNormalSegmentsToTumorSegments, int paddingInBp, String callAnnotation, double reciprocalThreshold) {
        HashMap<AnnotatedInterval, CalledCopyRatioSegment.Call> result = new HashMap<AnnotatedInterval, CalledCopyRatioSegment.Call>();
        for (AnnotatedInterval normalSeg : nonZeroMergedNormalSegmentsToTumorSegments.keySet()) {
            List<AnnotatedInterval> overlappingTumorSegments = nonZeroMergedNormalSegmentsToTumorSegments.get(normalSeg);
            List<AnnotatedInterval> mergedTumorSegments = SimpleGermlineTagger.mergedRegionsByAnnotation(callAnnotation, overlappingTumorSegments);
            boolean isReciprocalOverlapSeen = mergedTumorSegments.stream().anyMatch(s -> IntervalUtils.isReciprocalOverlap(s.getInterval(), normalSeg.getInterval(), reciprocalThreshold));
            boolean isStartPositionSeen = overlappingTumorSegments.stream().anyMatch(s -> Math.abs(s.getStart() - normalSeg.getStart()) <= paddingInBp);
            boolean isEndPositionSeen = overlappingTumorSegments.stream().anyMatch(s -> Math.abs(s.getEnd() - normalSeg.getEnd()) <= paddingInBp);
            if ((!isStartPositionSeen || !isEndPositionSeen) && !isReciprocalOverlapSeen) continue;
            CalledCopyRatioSegment.Call normalCall = Arrays.stream(CalledCopyRatioSegment.Call.values()).filter(c -> c.getOutputString().equals(normalSeg.getAnnotationValue(callAnnotation))).findFirst().orElse(null);
            if (normalCall == null) {
                throw new UserException.BadInput("No call exists in normal segment.  Does normal input have a call field \"" + callAnnotation + "\"?");
            }
            result.putAll(overlappingTumorSegments.stream().filter(s -> (Math.abs(s.getStart() - normalSeg.getStart()) <= paddingInBp || Math.abs(normalSeg.getEnd() - s.getEnd()) <= paddingInBp || normalSeg.getStart() < s.getStart() && normalSeg.getEnd() > s.getEnd()) && (double)normalSeg.getInterval().intersect((Locatable)s).size() > (double)s.getInterval().size() * reciprocalThreshold).collect(Collectors.toMap(Function.identity(), s -> normalCall)));
        }
        return result;
    }

    private static AnnotatedInterval createTumorTaggedSegment(AnnotatedInterval tumorSegment, String updateAnnotationName, String updateAnnotationValue) {
        Pair updatePair = Pair.of((Object)updateAnnotationName, (Object)updateAnnotationValue);
        return SimpleGermlineTagger.createTumorTaggedSegment(tumorSegment, Collections.singletonList(updatePair));
    }

    private static AnnotatedInterval createTumorTaggedSegment(AnnotatedInterval tumorSegment, List<Pair<String, String>> updateAnnotationNameValuePairs) {
        TreeMap<String, String> newAnnotations = new TreeMap<String, String>();
        newAnnotations.putAll((Map<String, String>)tumorSegment.getAnnotations());
        updateAnnotationNameValuePairs.forEach(p -> {
            String cfr_ignored_0 = (String)newAnnotations.put((String)p.getKey(), (String)p.getValue());
        });
        return new AnnotatedInterval(tumorSegment.getInterval(), newAnnotations);
    }

    private static List<AnnotatedInterval> mergedRegionsByAnnotation(String annotationToMerge, List<AnnotatedInterval> regions) {
        ArrayList<AnnotatedInterval> mergedSegments = new ArrayList<AnnotatedInterval>();
        PeekableIterator segmentsIterator = new PeekableIterator(regions.iterator());
        while (segmentsIterator.hasNext()) {
            AnnotatedInterval normalSegment = (AnnotatedInterval)segmentsIterator.next();
            AnnotatedInterval nextSegment = (AnnotatedInterval)segmentsIterator.peek();
            int updatedEndPoint = normalSegment.getEnd();
            while (segmentsIterator.hasNext() && SimpleGermlineTagger.isMergeableByAnnotation(annotationToMerge, normalSegment, nextSegment)) {
                updatedEndPoint = nextSegment.getEnd();
                segmentsIterator.next();
                nextSegment = (AnnotatedInterval)segmentsIterator.peek();
            }
            AnnotatedInterval segmentToAddToResult = new AnnotatedInterval(new SimpleInterval(normalSegment.getContig(), normalSegment.getStart(), updatedEndPoint), (SortedMap<String, String>)ImmutableSortedMap.of((Comparable)((Object)annotationToMerge), (Object)normalSegment.getAnnotationValue(annotationToMerge)));
            mergedSegments.add(segmentToAddToResult);
        }
        return mergedSegments;
    }

    private static boolean isMergeableByAnnotation(String annotationToMerge, AnnotatedInterval segment, AnnotatedInterval nextSegment) {
        return segment.getAnnotationValue(annotationToMerge).equals(nextSegment.getAnnotationValue(annotationToMerge)) && segment.getContig().equals(nextSegment.getContig()) && segment.getAnnotationValue(annotationToMerge) != null;
    }
}

