/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber.utils.optimization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.utils.Utils;

public final class PersistenceOptimizer {
    private static final int NO_COLOR = -1;
    private final double[] data;
    private final List<Integer> minimaIndices;
    private final List<Double> persistences;

    public PersistenceOptimizer(double[] data) {
        Utils.nonNull(data);
        Utils.validateArg(data.length > 0, "Data must contain at least one element.");
        this.data = Arrays.copyOf(data, data.length);
        List<Integer> sortedIndices = IntStream.range(0, this.data.length).boxed().sorted(Comparator.comparingDouble(i -> this.data[i])).collect(Collectors.toList());
        List<ExtremaPair> extremaPairs = PersistenceOptimizer.findExtremaPairs(this.data, sortedIndices);
        this.minimaIndices = extremaPairs.stream().map(p -> ((ExtremaPair)p).minIndex).collect(Collectors.toList());
        this.minimaIndices.add(0, sortedIndices.get(0));
        this.persistences = extremaPairs.stream().map(p -> ((ExtremaPair)p).persistence).collect(Collectors.toList());
        this.persistences.add(0, this.data[sortedIndices.get(sortedIndices.size() - 1)] - this.data[sortedIndices.get(0)]);
    }

    public List<Integer> getMinimaIndices() {
        return Collections.unmodifiableList(this.minimaIndices);
    }

    public List<Double> getPersistences() {
        return Collections.unmodifiableList(this.persistences);
    }

    private static List<ExtremaPair> findExtremaPairs(double[] data, List<Integer> sortedIndices) {
        ArrayList<Component> components = new ArrayList<Component>(data.length);
        int[] colors = new int[data.length];
        Arrays.fill(colors, -1);
        ArrayList<ExtremaPair> extremaPairs = new ArrayList<ExtremaPair>(data.length);
        if (data.length == 1) {
            return Collections.emptyList();
        }
        for (int index : sortedIndices) {
            if (index == 0) {
                if (colors[index + 1] == -1) {
                    PersistenceOptimizer.createComponent(data, components, colors, index);
                    continue;
                }
                PersistenceOptimizer.extendComponent(components, colors, colors[index + 1], index);
                continue;
            }
            if (index == data.length - 1) {
                if (colors[index - 1] == -1) {
                    PersistenceOptimizer.createComponent(data, components, colors, index);
                    continue;
                }
                PersistenceOptimizer.extendComponent(components, colors, colors[index - 1], index);
                continue;
            }
            int leftColor = colors[index - 1];
            int rightColor = colors[index + 1];
            if (leftColor == -1 && rightColor == -1) {
                PersistenceOptimizer.createComponent(data, components, colors, index);
                continue;
            }
            if (leftColor != -1 && rightColor == -1) {
                PersistenceOptimizer.extendComponent(components, colors, leftColor, index);
                continue;
            }
            if (leftColor == -1 && rightColor != -1) {
                PersistenceOptimizer.extendComponent(components, colors, rightColor, index);
                continue;
            }
            if (((Component)components.get(rightColor)).minValue < ((Component)components.get(leftColor)).minValue) {
                extremaPairs.add(new ExtremaPair(data, ((Component)components.get(leftColor)).minIndex, index));
            } else {
                extremaPairs.add(new ExtremaPair(data, ((Component)components.get(rightColor)).minIndex, index));
            }
            PersistenceOptimizer.mergeComponents(components, colors, leftColor, rightColor, index);
        }
        return extremaPairs.stream().sorted(Comparator.comparingDouble(p -> ((ExtremaPair)p).persistence).reversed()).collect(Collectors.toList());
    }

    private static void createComponent(double[] data, List<Component> components, int[] colors, int index) {
        colors[index] = components.size();
        components.add(new Component(index, data[index]));
    }

    private static void extendComponent(List<Component> components, int[] colors, int componentIndex, int index) {
        if (index + 1 == components.get(componentIndex).leftIndex) {
            components.get(componentIndex).leftIndex = index;
        } else if (index - 1 == components.get(componentIndex).rightIndex) {
            components.get(componentIndex).rightIndex = index;
        }
        colors[index] = componentIndex;
    }

    private static void mergeComponents(List<Component> components, int[] colors, int leftColor, int rightColor, int index) {
        int indexToMerge;
        int indexToKeep;
        if (components.get(leftColor).minValue < components.get(rightColor).minValue) {
            indexToKeep = leftColor;
            indexToMerge = rightColor;
        } else if (components.get(leftColor).minValue > components.get(rightColor).minValue) {
            indexToKeep = rightColor;
            indexToMerge = leftColor;
        } else if (leftColor < rightColor) {
            indexToKeep = leftColor;
            indexToMerge = rightColor;
        } else {
            indexToKeep = rightColor;
            indexToMerge = leftColor;
        }
        colors[((Component)components.get((int)indexToMerge)).leftIndex] = indexToKeep;
        colors[((Component)components.get((int)indexToMerge)).rightIndex] = indexToKeep;
        if (components.get(indexToKeep).minIndex > components.get(indexToMerge).minIndex) {
            components.get(indexToKeep).leftIndex = components.get(indexToMerge).leftIndex;
        } else {
            components.get(indexToKeep).rightIndex = components.get(indexToMerge).rightIndex;
        }
        colors[index] = colors[index - 1];
    }

    private static final class ExtremaPair {
        private final int minIndex;
        private final int maxIndex;
        private final double persistence;

        private ExtremaPair(double[] data, int datumIndex1, int datumIndex2) {
            if (data[datumIndex1] > data[datumIndex2]) {
                this.minIndex = datumIndex2;
                this.maxIndex = datumIndex1;
            } else if (data[datumIndex1] < data[datumIndex2]) {
                this.minIndex = datumIndex1;
                this.maxIndex = datumIndex2;
            } else if (datumIndex1 < datumIndex2) {
                this.minIndex = datumIndex1;
                this.maxIndex = datumIndex2;
            } else {
                this.minIndex = datumIndex2;
                this.maxIndex = datumIndex1;
            }
            this.persistence = data[this.maxIndex] - data[this.minIndex];
        }
    }

    private static final class Component {
        private int leftIndex;
        private int rightIndex;
        private final int minIndex;
        private final double minValue;

        private Component(int minIndex, double minValue) {
            this.leftIndex = minIndex;
            this.rightIndex = minIndex;
            this.minIndex = minIndex;
            this.minValue = minValue;
        }
    }
}

