/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.dragstr;

import htsjdk.samtools.SAMSequenceRecord;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

final class BufferedReferenceBases {
    private final String contigID;
    private final long length;
    private int bufferSize;
    private byte[] buffer;
    private byte[] previousBuffer;
    private final ReferenceDataSource dataSource;
    private long bufferStart;
    private long bufferEnd;

    private BufferedReferenceBases(ReferenceDataSource dataSource, String contigID, long length, int bufferSize) {
        this.dataSource = dataSource;
        this.contigID = contigID;
        this.length = length;
        this.bufferSize = (int)Math.min((long)bufferSize, length);
        this.buffer = null;
        this.previousBuffer = null;
        this.bufferStart = -1L;
        this.bufferEnd = -1L;
    }

    public String contigID() {
        return this.contigID;
    }

    private void loadStartingAt(long start) {
        long maximumEnd = start + (long)this.bufferSize - 1L;
        long newEnd = Math.min(maximumEnd, this.length);
        this.previousBuffer = this.buffer != null && this.bufferStart == start - (long)this.buffer.length ? this.buffer : null;
        this.buffer = this.dataSource.queryAndPrefetch(this.contigID, start, newEnd).getBases();
        this.bufferStart = start;
        this.bufferEnd = newEnd;
    }

    public static BufferedReferenceBases of(ReferenceDataSource dataSource, String contigId, int bufferSize) {
        Utils.nonNull(dataSource);
        Utils.nonNull(contigId);
        ParamUtils.isPositive(bufferSize, "buffer size");
        SAMSequenceRecord sequenceRecord = dataSource.getSequenceDictionary().getSequence(contigId);
        if (sequenceRecord == null) {
            throw new IllegalArgumentException("there is not such sequence/contig id " + contigId + " in input data-source");
        }
        return new BufferedReferenceBases(dataSource, contigId, sequenceRecord.getSequenceLength(), bufferSize);
    }

    public long length() {
        return this.length;
    }

    final int copyBytesAt(long position, byte[] dest, int offset, int requestLength) {
        long lastPosition = Math.min(this.length, position + (long)requestLength - 1L);
        long p = position;
        int o = offset;
        while (p <= lastPosition) {
            dest[o] = this.byteAt(p);
            ++p;
            ++o;
        }
        return (int)(lastPosition - position + 1L);
    }

    byte byteAt(long location) {
        if (location < this.bufferStart) {
            if (location < 0L) {
                throw new IllegalArgumentException("invalid location outside range: " + location);
            }
            if (this.previousBuffer != null && location >= this.bufferStart - (long)this.previousBuffer.length) {
                return this.previousBuffer[(int)(location - (this.bufferStart - (long)this.previousBuffer.length))];
            }
            this.loadStartingAt(location);
            return this.buffer[0];
        }
        if (location > this.bufferEnd) {
            if (location > this.length) {
                throw new IllegalArgumentException("invalid location");
            }
            this.loadStartingAt(location);
            return this.buffer[0];
        }
        return this.buffer[(int)(location - this.bufferStart)];
    }
}

