/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.dragstr;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFlag;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.IntervalTree;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.output.NullOutputStream;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.ShortVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.GATKTool;
import org.broadinstitute.hellbender.engine.ReadsDataSource;
import org.broadinstitute.hellbender.engine.ReadsDataSourcePool;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.dragstr.DragstrHyperParameters;
import org.broadinstitute.hellbender.tools.dragstr.DragstrLocus;
import org.broadinstitute.hellbender.tools.dragstr.DragstrLocusCase;
import org.broadinstitute.hellbender.tools.dragstr.DragstrLocusCases;
import org.broadinstitute.hellbender.tools.dragstr.DragstrParametersEstimator;
import org.broadinstitute.hellbender.tools.dragstr.STRDecimationTable;
import org.broadinstitute.hellbender.tools.dragstr.StratifiedDragstrLocusCases;
import org.broadinstitute.hellbender.transformers.DRAGENMappingQualityReadTransformer;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.BinaryTableReader;
import org.broadinstitute.hellbender.utils.IntervalMergingRule;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SequenceDictionaryUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParamUtils;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParams;
import org.broadinstitute.hellbender.utils.dragstr.STRTableFile;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.reference.AbsoluteCoordinates;

@CommandLineProgramProperties(summary="estimates the parameters for the DRAGstr model for the input sample using the output of the ComposeSTRTable tool", oneLineSummary="estimates the parameters for the DRAGstr model", programGroup=ShortVariantDiscoveryProgramGroup.class)
@BetaFeature
@DocumentedFeature
public class CalibrateDragstrModel
extends GATKTool {
    public static final String STR_TABLE_PATH_SHORT_NAME = "str";
    public static final String STR_TABLE_PATH_FULL_NAME = "str-table-path";
    public static final String PARALLEL_FULL_NAME = "parallel";
    public static final String THREADS_FULL_NAME = "threads";
    public static final String SHARD_SIZE_FULL_NAME = "shard-size";
    public static final String DOWN_SAMPLE_SIZE_FULL_NAME = "down-sample-size";
    public static final String DEBUG_SITES_OUTPUT_FULL_NAME = "debug-sites-output";
    public static final int DEFAULT_SHARD_SIZE = 1000000;
    public static final int DEFAULT_DOWN_SAMPLE_SIZE = 4096;
    public static final int SYSTEM_SUGGESTED_THREAD_NUMBER = 0;
    public static final int MINIMUM_SHARD_SIZE = 100;
    public static final int MINIMUM_DOWN_SAMPLE_SIZE = 512;
    @ArgumentCollection
    private DragstrHyperParameters hyperParameters = new DragstrHyperParameters();
    @Argument(shortName="str", fullName="str-table-path", doc="location of the zip that contains the sampling sites for the reference")
    private GATKPath strTablePath = null;
    @Argument(fullName="parallel", doc="run alignment data collection and  estimation in parallel", optional=true)
    private boolean runInParallel = false;
    @Argument(fullName="threads", minValue=0.0, doc="suggested number of parallel threads to perform the estimation, the default 0 leave it up to the VM to decide. When set to more than 1, this will activate parallel in the absence of --parallel", optional=true)
    private int threads = 0;
    @Argument(fullName="shard-size", doc="when running in parallel this is the suggested shard size in base pairs. The actual shard-size may vary to adapt to small contigs and the requested number of threads", minValue=100.0, optional=true)
    private int shardSize = 1000000;
    @Argument(fullName="down-sample-size", doc="Targeted maximum number of cases per combination period repeat count, the larger the more precise but also the slower estimation.", minValue=512.0, optional=true)
    private int downsampleSize = 4096;
    @Argument(fullName="output", shortName="O", doc="where to write the parameter output file.")
    private GATKPath output = null;
    @Argument(fullName="debug-sites-output", doc="table with information gather on the samples sites. Includes what sites were downsampled, disqualified or accepted for parameter estimation", optional=true)
    private String sitesOutput = null;
    private SAMSequenceDictionary dictionary;
    public static final ReadTransformer EXTENDED_MQ_READ_TRANSFORMER = new DRAGENMappingQualityReadTransformer();
    private static final int[][] MINIMUM_CASES_BY_PERIOD_AND_LENGTH = new int[][]{new int[0], {0, 200, 200, 200, 200, 200, 200, 200, 200, 200, 0}, {0, 0, 200, 200, 200, 200, 0, 0, 0, 0, 0}, {0, 0, 200, 200, 200, 0, 0, 0, 0, 0, 0}, {0, 0, 200, 200, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 200, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 200, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 200, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 200, 0, 0, 0, 0, 0, 0, 0, 0}};
    private static final long[] DECIMATION_MASKS_BY_BIT = new long[64];
    private static final EnumSet<SAMFlag> DISCARD_FLAGS;
    private static final int DISCARD_FLAG_VALUE;

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    protected void onStartup() {
        super.onStartup();
        this.hyperParameters.validate();
        this.dictionary = this.directlyAccessEngineReadsDataSource().getSequenceDictionary();
        if (this.runInParallel) {
            if (this.threads == 1) {
                this.logger.warn("parallel processing was requested but the number of threads was set to 1");
            }
        } else if (this.threads > 1) {
            this.runInParallel = true;
        }
        if (this.runInParallel) {
            if (this.threads == 0) {
                this.logger.info("Running in parallel using the system suggested default thread count: " + Runtime.getRuntime().availableProcessors());
            } else {
                this.logger.info("Running in parallel using the requested number of threads: " + this.threads);
            }
        }
    }

    @Override
    public void traverse() {
        this.hyperParameters.validate();
        this.dictionary = this.getBestAvailableSequenceDictionary();
        List readGroups = this.hasReads() ? this.getHeaderForReads().getReadGroups() : Collections.emptyList();
        List<String> readGroupIds = readGroups.stream().map(SAMReadGroupRecord::getId).collect(Collectors.toList());
        List<String> sampleNames = readGroups.stream().map(SAMReadGroupRecord::getSample).distinct().collect(Collectors.toList());
        Optional<String> sampleName = this.resolveSampleName(sampleNames);
        try (PrintWriter sitesOutputWriter = this.openSitesOutputWriter(this.sitesOutput);
             STRTableFile strTable = STRTableFile.open(this.strTablePath);){
            StratifiedDragstrLocusCases allSites;
            this.checkSequenceDictionaryCompatibility(this.dictionary, strTable.dictionary());
            List<SimpleInterval> intervals = this.getTraversalIntervals();
            this.runInParallel |= this.threads > 1;
            if (this.runInParallel) {
                if (this.threads == 1) {
                    this.logger.warn("parallel processing was requested but the number of threads was set to 1");
                }
                allSites = this.collectCaseStatsParallel(intervals, this.shardSize, strTable);
            } else {
                allSites = this.collectCaseStatsSequencial(intervals, strTable);
            }
            this.logSiteCounts(allSites, "all loci/cases");
            StratifiedDragstrLocusCases downSampledSites = this.downSample(allSites, strTable, sitesOutputWriter);
            this.logSiteCounts(downSampledSites, "all downsampled (kept) loci/cases");
            StratifiedDragstrLocusCases finalSites = downSampledSites.qualifyingOnly(this.hyperParameters.minDepth, this.hyperParameters.minMQ, 0);
            this.logSiteCounts(finalSites, "all qualifying loci/cases");
            this.outputDownSampledSiteDetails(downSampledSites, sitesOutputWriter, this.hyperParameters.minDepth, this.hyperParameters.minMQ, 0);
            this.printOutput(finalSites, sampleName.orElse(null), readGroupIds);
        }
    }

    private void printOutput(StratifiedDragstrLocusCases finalSites, String sampleName, List<String> readGroups) {
        boolean usingDefaults = !this.isThereEnoughCases(finalSites);
        Object[] annotations = new Object[]{"sample", sampleName == null ? "<unspecified>" : sampleName, "readGroups", readGroups.isEmpty() ? "<unspecified>" : Utils.join(", ", readGroups), "estimatedOrDefaults", usingDefaults ? "defaults" : "estimated", "commandLine", this.getCommandLine()};
        if (!usingDefaults) {
            this.logger.info("Estimating parameters used sampled down cases");
            DragstrParams estimate = this.estimateParams(finalSites);
            this.logger.info("Done with estimation, printing output");
            DragstrParamUtils.print(estimate, this.output, annotations);
        } else {
            this.logger.warn("Not enough cases to estimate parameters, using defaults");
            DragstrParamUtils.print(DragstrParams.DEFAULT, this.output, annotations);
        }
    }

    private Optional<String> resolveSampleName(List<String> sampleNames) {
        if (sampleNames.size() > 1) {
            throw new GATKException("the input alignment(s) have more than one sample: " + String.join((CharSequence)", ", sampleNames));
        }
        if (sampleNames.isEmpty() || sampleNames.get(0) == null) {
            this.logger.warn("there is no sample id in the alignment header, assuming that all reads and read/groups make reference to the same anonymous sample");
            return Optional.empty();
        }
        return Optional.of(sampleNames.get(0));
    }

    private void checkSequenceDictionaryCompatibility(SAMSequenceDictionary reference, SAMSequenceDictionary strTable) {
        SequenceDictionaryUtils.SequenceDictionaryCompatibility compatibility = SequenceDictionaryUtils.compareDictionaries(reference, strTable, false);
        switch (compatibility) {
            case IDENTICAL: {
                return;
            }
            case SUPERSET: {
                return;
            }
            case NON_CANONICAL_HUMAN_ORDER: {
                return;
            }
            case OUT_OF_ORDER: {
                return;
            }
        }
        throw new GATKException("the reference and str-table sequence dictionary are incompatible: " + (Object)((Object)compatibility));
    }

    private PrintWriter openSitesOutputWriter(String sitesOutput) {
        return sitesOutput == null ? new PrintWriter((OutputStream)new NullOutputStream()) : new PrintWriter(BucketUtils.createFile(sitesOutput));
    }

    private void outputDownSampledSiteDetails(StratifiedDragstrLocusCases finalSites, PrintWriter writer, int minDepth, int samplingMinMQ, int maxSup) {
        if (this.sitesOutput != null) {
            DragstrLocusCases[][] dragstrLocusCasesArray = finalSites.perPeriodAndRepeat;
            int n = dragstrLocusCasesArray.length;
            for (int i = 0; i < n; ++i) {
                DragstrLocusCases[] periodCases;
                for (DragstrLocusCases repeatCases : periodCases = dragstrLocusCasesArray[i]) {
                    Iterator iterator = repeatCases.iterator();
                    while (iterator.hasNext()) {
                        DragstrLocusCase caze;
                        CalibrateDragstrModel.outputSiteDetails(writer, caze, (caze = (DragstrLocusCase)iterator.next()).qualifies(minDepth, samplingMinMQ, maxSup) ? "used" : "skipped");
                    }
                }
            }
        }
    }

    private boolean isThereEnoughCases(StratifiedDragstrLocusCases allSites) {
        int[][] MCBL = MINIMUM_CASES_BY_PERIOD_AND_LENGTH;
        int maxP = Math.min(this.hyperParameters.maxPeriod, MCBL.length - 1);
        for (int i = 1; i <= maxP; ++i) {
            int maxL = Math.min(this.hyperParameters.maxRepeatLength, MCBL[i].length - 1);
            for (int j = 1; j <= maxL; ++j) {
                if (allSites.get(i, j).size() >= MCBL[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    private DragstrParams estimateParams(StratifiedDragstrLocusCases finalSites) {
        DragstrParametersEstimator estimator = new DragstrParametersEstimator(this.hyperParameters);
        return this.runInParallel ? Utils.runInParallel(this.threads, () -> estimator.estimate(finalSites)) : estimator.estimate(finalSites);
    }

    private StratifiedDragstrLocusCases downSample(StratifiedDragstrLocusCases allSites, STRTableFile strTable, PrintWriter sitesOutputWriter) {
        STRDecimationTable decimationTable = strTable.decimationTable();
        ArrayList<PeriodAndRepeatLength> prCombos = new ArrayList<PeriodAndRepeatLength>(this.hyperParameters.maxPeriod * this.hyperParameters.maxRepeatLength);
        for (int i = 1; i <= this.hyperParameters.maxPeriod; ++i) {
            for (int j = 1; j <= this.hyperParameters.maxRepeatLength; ++j) {
                prCombos.add(PeriodAndRepeatLength.of(i, j));
            }
        }
        Stream prCombosStream = this.runInParallel ? prCombos.parallelStream() : prCombos.stream();
        Stream<StratifiedDragstrLocusCases> downsampledStream = prCombosStream.flatMap(combo -> {
            DragstrLocusCases all = allSites.perPeriodAndRepeat[((PeriodAndRepeatLength)combo).period - 1][((PeriodAndRepeatLength)combo).repeatLength - 1];
            int decimationBit = decimationTable.decimationBit(((PeriodAndRepeatLength)combo).period, ((PeriodAndRepeatLength)combo).repeatLength);
            return this.downSample(all, decimationBit, this.downsampleSize, sitesOutputWriter).stream();
        });
        if (this.runInParallel) {
            return Utils.runInParallel(this.threads, () -> downsampledStream.collect(DragstrLocusCaseStratificator.make(this.hyperParameters.maxPeriod, this.hyperParameters.maxRepeatLength)));
        }
        return downsampledStream.collect(DragstrLocusCaseStratificator.make(this.hyperParameters.maxPeriod, this.hyperParameters.maxRepeatLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DragstrLocusCases downSample(DragstrLocusCases in, int minDecimationBit, int downsampleSize, PrintWriter sitesOutputWriter) {
        int inSize = in.size();
        if (inSize <= downsampleSize) {
            return in;
        }
        int zeroDepth = 0;
        int[] countByFirstDecimatingBit = new int[64 - minDecimationBit];
        block3: for (DragstrLocusCase caze : in) {
            DragstrLocus locus = caze.getLocus();
            int depth = caze.getDepth();
            if (depth <= 0) {
                ++zeroDepth;
                continue;
            }
            long mask = locus.getMask();
            for (int j = minDecimationBit; mask != 0L && j < 64; ++j) {
                long newMask = mask & DECIMATION_MASKS_BY_BIT[j];
                if (newMask == mask) continue;
                int n = j;
                countByFirstDecimatingBit[n] = countByFirstDecimatingBit[n] + 1;
                continue block3;
            }
        }
        IntArrayList progressiveSizes = new IntArrayList(65);
        progressiveSizes.add(inSize);
        int finalSize = inSize - zeroDepth;
        progressiveSizes.add(finalSize);
        long filterMask = 0L;
        for (int j = minDecimationBit; finalSize > downsampleSize && j < 64; ++j) {
            filterMask |= DECIMATION_MASKS_BY_BIT[j] ^ 0xFFFFFFFFFFFFFFFFL;
            progressiveSizes.add(finalSize -= countByFirstDecimatingBit[j]);
        }
        DragstrLocusCases discarded = new DragstrLocusCases(finalSize, in.getPeriod(), in.getRepeatLength());
        DragstrLocusCases result = new DragstrLocusCases(in.size() - finalSize, in.getPeriod(), in.getRepeatLength());
        for (DragstrLocusCase caze : in) {
            long mask = caze.getLocus().getMask();
            if ((mask & filterMask) == 0L & caze.getDepth() > 0) {
                discarded.add(caze);
                continue;
            }
            result.add(caze);
        }
        this.logger.debug(() -> CalibrateDragstrModel.lambda$downSample$3(in, (IntList)progressiveSizes));
        if (this.sitesOutput != null && result.size() > 0) {
            CalibrateDragstrModel calibrateDragstrModel = this;
            synchronized (calibrateDragstrModel) {
                for (DragstrLocusCase caze : result) {
                    CalibrateDragstrModel.outputSiteDetails(sitesOutputWriter, caze, "downsampled-out");
                }
            }
        }
        return discarded;
    }

    private void logSiteCounts(StratifiedDragstrLocusCases cases, String title) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(title);
            int[] columnWidths = IntStream.range(1, this.hyperParameters.maxPeriod + 1).map(period -> {
                int max = IntStream.range(1, this.hyperParameters.maxRepeatLength + 1).map(repeat -> cases.get(period, repeat).size()).max().orElse(0);
                return (int)Math.max(7.0, Math.ceil(Math.log10(max)) + 1.0);
            }).toArray();
            this.logger.debug("      " + IntStream.range(0, this.hyperParameters.maxPeriod).mapToObj(i -> String.format("%-" + columnWidths[i] + "s", i + 1)).collect(Collectors.joining()));
            int i2 = 1;
            while (i2 <= this.hyperParameters.maxRepeatLength) {
                int repeat = i2++;
                this.logger.debug(String.format("%-4s", repeat) + "  " + IntStream.range(1, this.hyperParameters.maxPeriod + 1).mapToObj(period -> String.format("%-" + columnWidths[period - 1] + "s", cases.get(period, repeat).size())).collect(Collectors.joining("")));
            }
        }
    }

    private StratifiedDragstrLocusCases collectCaseStatsSequencial(List<SimpleInterval> intervals, STRTableFile strTable) {
        StratifiedDragstrLocusCases result = StratifiedDragstrLocusCases.make(this.hyperParameters.maxPeriod, this.hyperParameters.maxRepeatLength);
        ReadsDataSource dataSource = this.directlyAccessEngineReadsDataSource();
        for (SimpleInterval interval : intervals) {
            try {
                BinaryTableReader<DragstrLocus> reader = strTable.locusReader(interval);
                Throwable throwable = null;
                try {
                    this.streamShardCasesStats(interval, this.readStream(dataSource, interval), reader.stream()).peek(caze -> this.progressMeter.update(caze.getLocation(this.dictionary))).forEach(result::add);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException ex) {
                throw new GATKException("problems accessing str-table-file at " + this.strTablePath);
            }
        }
        return result;
    }

    private StratifiedDragstrLocusCases collectCaseStatsParallel(List<SimpleInterval> intervals, int shardSize, STRTableFile strTable) {
        AbsoluteCoordinates absoluteCoordinates = AbsoluteCoordinates.of(this.dictionary);
        List<SimpleInterval> shards = this.shardIntervals(intervals, shardSize);
        try (ReadsDataSourcePool readsDataSourcePool = new ReadsDataSourcePool(this.readArguments.getReadPaths(), this.referenceArguments.getReferencePath());){
            AtomicLong numberBasesProcessed = new AtomicLong(0L);
            StratifiedDragstrLocusCases stratifiedDragstrLocusCases = Utils.runInParallel(this.threads, () -> shards.parallelStream().map(shard -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.getAnalysis(Method.java:520)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:351)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }).reduce((xva$0, xva$1) -> StratifiedDragstrLocusCases.merge(xva$0, xva$1)).orElseGet(() -> new StratifiedDragstrLocusCases(this.hyperParameters.maxPeriod, this.hyperParameters.maxRepeatLength)));
            return stratifiedDragstrLocusCases;
        }
    }

    private List<SimpleInterval> shardIntervals(List<SimpleInterval> raw, int shardSize) {
        List<SimpleInterval> preSharded = this.sortAndMergeOverlappingIntervals(raw, this.dictionary);
        long size = preSharded.stream().mapToLong(SimpleInterval::size).sum();
        ArrayList<SimpleInterval> output = new ArrayList<SimpleInterval>((int)((long)preSharded.size() + size / (long)shardSize));
        int shardingSizeThreshold = (int)Math.round((double)shardSize * 1.5);
        for (SimpleInterval in : preSharded) {
            if (in.size() < shardingSizeThreshold) {
                output.add(in);
                continue;
            }
            int start = in.getStart();
            int inEnd = in.getEnd();
            int stop = in.getEnd() - shardingSizeThreshold + 1;
            while (start < stop) {
                int end = start + shardSize - 1;
                output.add(new SimpleInterval(in.getContig(), start, end));
                start = end + 1;
            }
            if (start > inEnd) continue;
            output.add(new SimpleInterval(in.getContig(), start, inEnd));
        }
        return output;
    }

    private List<SimpleInterval> sortAndMergeOverlappingIntervals(List<SimpleInterval> input, SAMSequenceDictionary dictionary) {
        if (this.isSortedAndHasNoOverlap(input, dictionary)) {
            return input;
        }
        Map<String, List<SimpleInterval>> byContig = IntervalUtils.sortAndMergeIntervals(input, dictionary, IntervalMergingRule.ALL);
        return byContig.keySet().stream().sorted(Comparator.comparingInt(name -> dictionary.getSequence(name).getSequenceIndex())).flatMap(name -> ((List)byContig.get(name)).stream()).collect(Collectors.toList());
    }

    private boolean isSortedAndHasNoOverlap(List<SimpleInterval> input, SAMSequenceDictionary dictionary) {
        if (input.isEmpty()) {
            return true;
        }
        String prevCtgName = null;
        int prevCtgIdx = -1;
        int prevEnd = 0;
        for (SimpleInterval interval : input) {
            String ctg = interval.getContig();
            int start = interval.getStart();
            int end = interval.getEnd();
            if (ctg.equals(prevCtgName)) {
                if (start <= prevEnd) {
                    return false;
                }
                prevEnd = end;
                continue;
            }
            int ctgIdx = dictionary.getSequenceIndex(ctg);
            if (ctgIdx <= prevCtgIdx) {
                return false;
            }
            prevCtgName = ctg;
            prevCtgIdx = ctgIdx;
            prevEnd = end;
        }
        return true;
    }

    private Stream<DragstrLocusCase> streamShardCasesStats(SimpleInterval shard, final Stream<GATKRead> reads, final Stream<DragstrLocus> loci) {
        final int contigLength = this.dictionary.getSequence(shard.getContig()).getSequenceLength();
        return StreamSupport.stream(new Spliterator<DragstrLocusCase>(){
            private final Spliterator<GATKRead> readSpliterator;
            private final Spliterator<DragstrLocus> lociSpliterator;
            private final ShardReadBuffer readBuffer;
            private GATKRead read;
            private DragstrLocus locus;
            {
                this.readSpliterator = reads.spliterator();
                this.lociSpliterator = loci.spliterator();
                this.readBuffer = new ShardReadBuffer();
            }

            private boolean advanceRead() {
                return this.readSpliterator.tryAdvance((? super T read) -> {
                    this.read = read;
                });
            }

            private boolean advanceLocus() {
                return this.lociSpliterator.tryAdvance((? super T locus) -> {
                    this.locus = locus;
                });
            }

            @Override
            public boolean tryAdvance(Consumer<? super DragstrLocusCase> action) {
                if (this.advanceLocus()) {
                    this.readBuffer.removeUpstreamFrom((int)this.locus.getStart());
                    while (this.advanceRead()) {
                        this.readBuffer.add(this.read.getAssignedStart(), this.read.getEnd(), this.read);
                        if ((long)this.read.getAssignedStart() <= this.locus.getEnd()) continue;
                    }
                    List<EquivalentReadSet> reads2 = this.readBuffer.overlapping((int)this.locus.getStart(), (int)this.locus.getEnd());
                    DragstrLocusCase newCase = CalibrateDragstrModel.this.composeDragstrLocusCase(this.locus, reads2, contigLength);
                    action.accept(newCase);
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<DragstrLocusCase> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return 0L;
            }

            @Override
            public int characteristics() {
                return 0;
            }
        }, false);
    }

    private static void outputSiteDetails(PrintWriter writer, DragstrLocusCase caze, String fate) {
        writer.println(Utils.join((CharSequence)"\t", "" + caze.getLocus().getChromosomeIndex() + ':' + (caze.getLocus().getStart() - 1L), caze.getLocus().getPeriod(), caze.getLocus().getRepeats(), caze.getDepth(), caze.getIndels(), caze.getMinMQ(), caze.getNSup(), fate));
    }

    private Stream<GATKRead> readStream(ReadsDataSource source, SimpleInterval interval) {
        Stream<GATKRead> unfiltered = interval == null ? Utils.stream(source) : Utils.stream(source.query(interval));
        return unfiltered.filter(read -> (read.getFlags() & DISCARD_FLAG_VALUE) == 0).map(EXTENDED_MQ_READ_TRANSFORMER);
    }

    private DragstrLocusCase composeDragstrLocusCase(DragstrLocus locus, List<EquivalentReadSet> rawReads, long contigLength) {
        return rawReads.stream().collect(DragstrLocusCaseCollector.create(locus, this.hyperParameters.strPadding, contigLength));
    }

    private static /* synthetic */ long lambda$null$9(SimpleInterval shard, long l) {
        return l + (long)shard.size();
    }

    private static /* synthetic */ Object lambda$downSample$3(DragstrLocusCases in, IntList progressiveSizes) {
        return "" + in.getPeriod() + " " + in.getRepeatLength() + " " + Arrays.toString(progressiveSizes.toArray());
    }

    static {
        CalibrateDragstrModel.DECIMATION_MASKS_BY_BIT[0] = 1L;
        int i = 1;
        int j = 0;
        while (i < 64) {
            CalibrateDragstrModel.DECIMATION_MASKS_BY_BIT[i] = DECIMATION_MASKS_BY_BIT[j] << 1;
            CalibrateDragstrModel.DECIMATION_MASKS_BY_BIT[j] = DECIMATION_MASKS_BY_BIT[j] ^ 0xFFFFFFFFFFFFFFFFL;
            ++i;
            ++j;
        }
        CalibrateDragstrModel.DECIMATION_MASKS_BY_BIT[63] = DECIMATION_MASKS_BY_BIT[63] ^ 0xFFFFFFFFFFFFFFFFL;
        DISCARD_FLAGS = EnumSet.of(SAMFlag.READ_UNMAPPED, SAMFlag.SECONDARY_ALIGNMENT, SAMFlag.READ_FAILS_VENDOR_QUALITY_CHECK);
        DISCARD_FLAG_VALUE = DISCARD_FLAGS.stream().mapToInt(SAMFlag::intValue).sum();
    }

    private static class PeriodAndRepeatLength {
        private final int period;
        private final int repeatLength;

        private PeriodAndRepeatLength(int period, int repeatLength) {
            this.period = period;
            this.repeatLength = repeatLength;
        }

        private static PeriodAndRepeatLength of(int period, int repeat) {
            return new PeriodAndRepeatLength(period, repeat);
        }

        public String toString() {
            return "(" + this.period + ',' + this.repeatLength + ')';
        }
    }

    private static class ShardReadBuffer
    extends IntervalTree<Int2ObjectMap<EquivalentReadSet>> {
        private ShardReadBuffer() {
        }

        private static Int2ObjectMap<EquivalentReadSet> mergeEquivalentReadSets(Int2ObjectMap<EquivalentReadSet> left, Int2ObjectMap<EquivalentReadSet> right) {
            Int2ObjectMap<EquivalentReadSet> donor;
            Int2ObjectOpenHashMap receiver;
            if (left.size() > 1) {
                receiver = left;
                donor = right;
            } else if (right.size() > 1) {
                receiver = right;
                donor = left;
            } else {
                receiver = new Int2ObjectOpenHashMap(left);
                donor = right;
            }
            for (EquivalentReadSet e2 : donor.values()) {
                EquivalentReadSet e1 = (EquivalentReadSet)receiver.get(e2.hashCode());
                if (e1 == null) {
                    receiver.put(e2.hashCode(), (Object)e2);
                    continue;
                }
                e1.increase(e2.size());
            }
            return receiver;
        }

        public void add(int start, int end, GATKRead elem) {
            this.merge(start, end, Int2ObjectMaps.singleton((int)EquivalentReadSet.hashCode(elem), (Object)EquivalentReadSet.of(elem)), ShardReadBuffer::mergeEquivalentReadSets);
        }

        void removeUpstreamFrom(int start) {
            IntervalTree.Node node;
            Iterator it = this.iterator();
            while (it.hasNext() && (node = (IntervalTree.Node)it.next()).getStart() < start) {
                if (node.getEnd() >= start) continue;
                it.remove();
            }
        }

        public List<EquivalentReadSet> overlapping(int start, int end) {
            Iterator it = this.overlappers(start, end);
            if (!it.hasNext()) {
                return Collections.emptyList();
            }
            ArrayList<EquivalentReadSet> result = new ArrayList<EquivalentReadSet>();
            do {
                IntervalTree.Node node = (IntervalTree.Node)it.next();
                result.addAll((Collection<EquivalentReadSet>)((Int2ObjectMap)node.getValue()).values());
            } while (it.hasNext());
            return result;
        }
    }

    private static class EquivalentReadSet {
        private GATKRead example;
        private int size;

        public boolean belongs(GATKRead read) {
            return read.isSupplementaryAlignment() == this.example.isSupplementaryAlignment() && read.getMappingQuality() == this.example.getMappingQuality() && read.getCigar().equals((Object)this.example.getCigar());
        }

        public static int hashCode(GATKRead read) {
            return Boolean.hashCode(read.isSupplementaryAlignment()) * 31 + read.getMappingQuality() * 31 + read.getCigar().hashCode();
        }

        public int hashCode() {
            return EquivalentReadSet.hashCode(this.example);
        }

        private EquivalentReadSet(GATKRead read) {
            this.example = read;
            this.size = 1;
        }

        public static EquivalentReadSet of(GATKRead read) {
            Utils.nonNull(read);
            return new EquivalentReadSet(read);
        }

        public void increase(int inc) {
            this.size += inc;
        }

        public int getStart() {
            return this.example.getStart();
        }

        public int getEnd() {
            return this.example.getEnd();
        }

        public boolean isSupplementaryAlignment() {
            return this.example.isSupplementaryAlignment();
        }

        public int size() {
            return this.size;
        }

        public int getMappingQuality() {
            return this.example.getMappingQuality();
        }

        public Iterable<? extends CigarElement> getCigar() {
            return this.example.getCigar();
        }
    }

    private static class DragstrLocusCaseCollector
    implements Collector<EquivalentReadSet, DragstrLocusCaseCollector, DragstrLocusCase> {
        private final DragstrLocus locus;
        private final long strStart;
        private final long strEnd;
        private final long strEndPlusOne;
        private final long paddedStrStart;
        private final long paddedStrEnd;
        private int n;
        private int k;
        private int minMQ;
        private int nSup;

        private DragstrLocusCaseCollector(DragstrLocus locus, long strStart, long strEnd, long paddedStrStart, long paddedStrEnd) {
            this.locus = locus;
            this.strStart = strStart;
            this.strEnd = strEnd;
            this.strEndPlusOne = strEnd + 1L;
            this.paddedStrStart = paddedStrStart;
            this.paddedStrEnd = paddedStrEnd;
            this.nSup = 0;
            this.k = 0;
            this.n = 0;
            this.minMQ = 255;
        }

        public static DragstrLocusCaseCollector create(DragstrLocus locus, int padding, long contingLength) {
            Utils.nonNull(locus);
            Utils.validateArg(padding >= 0, "padding must be 0 or greater");
            Utils.validateArg(contingLength >= 1L, "contig length must be strictly positive");
            long strStart = locus.getStart();
            long strEnd = locus.getEnd();
            long paddedStrStart = Math.max(1L, strStart - (long)padding);
            long paddedStrEnd = Math.min(contingLength, strEnd + (long)padding);
            return new DragstrLocusCaseCollector(locus, strStart, strEnd, paddedStrStart, paddedStrEnd);
        }

        @Override
        public Supplier<DragstrLocusCaseCollector> supplier() {
            return () -> new DragstrLocusCaseCollector(this.locus, this.strStart, this.strEnd, this.paddedStrStart, this.paddedStrEnd);
        }

        @Override
        public BiConsumer<DragstrLocusCaseCollector, EquivalentReadSet> accumulator() {
            return DragstrLocusCaseCollector::collect;
        }

        private void collect(EquivalentReadSet eset) {
            int readStart = eset.getStart();
            int readEnd = eset.getEnd();
            int size = eset.size();
            if ((long)readStart <= this.paddedStrStart && (long)readEnd >= this.paddedStrEnd) {
                if (eset.isSupplementaryAlignment()) {
                    this.nSup += size;
                }
                this.minMQ = Math.min(this.minMQ, eset.getMappingQuality());
                int refPos = readStart;
                for (CigarElement cigarElement : eset.getCigar()) {
                    CigarOperator op = cigarElement.getOperator();
                    int length = cigarElement.getLength();
                    if (op == CigarOperator.I && (long)refPos >= this.strStart && (long)refPos <= this.strEndPlusOne) {
                        this.k += size;
                    } else if (op == CigarOperator.D && (long)(refPos + length - 1) >= this.strStart && (long)refPos <= this.strEnd) {
                        this.k += size;
                    }
                    if ((long)(refPos += op.consumesReferenceBases() ? length : 0) <= this.strEndPlusOne) continue;
                    break;
                }
                this.n += size;
            }
        }

        private DragstrLocusCaseCollector combineWith(DragstrLocusCaseCollector other) {
            Utils.validateArg(other.locus == this.locus, "collectors at different loci cannot be convined");
            DragstrLocusCaseCollector result = new DragstrLocusCaseCollector(this.locus, this.strStart, this.strEnd, this.paddedStrStart, this.paddedStrEnd);
            result.k = this.k + other.k;
            result.n = this.n + other.n;
            result.nSup = this.nSup + other.nSup;
            result.minMQ = Math.min(this.minMQ, other.minMQ);
            return result;
        }

        private DragstrLocusCase finish() {
            return DragstrLocusCase.create(this.locus, this.n, this.k, this.minMQ, this.nSup);
        }

        @Override
        public BinaryOperator<DragstrLocusCaseCollector> combiner() {
            return DragstrLocusCaseCollector::combineWith;
        }

        @Override
        public Function<DragstrLocusCaseCollector, DragstrLocusCase> finisher() {
            return DragstrLocusCaseCollector::finish;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }

    private static class DragstrLocusCaseStratificator
    implements Collector<DragstrLocusCase, StratifiedDragstrLocusCases, StratifiedDragstrLocusCases> {
        private final int maxPeriod;
        private final int maxRepeats;

        private static DragstrLocusCaseStratificator make(int maxPeriod, int maxRepeats) {
            return new DragstrLocusCaseStratificator(maxPeriod, maxRepeats);
        }

        private DragstrLocusCaseStratificator(int maxPeriod, int maxRepeats) {
            this.maxPeriod = maxPeriod;
            this.maxRepeats = maxRepeats;
        }

        @Override
        public Supplier<StratifiedDragstrLocusCases> supplier() {
            return () -> new StratifiedDragstrLocusCases(this.maxPeriod, this.maxRepeats);
        }

        @Override
        public BiConsumer<StratifiedDragstrLocusCases, DragstrLocusCase> accumulator() {
            return StratifiedDragstrLocusCases::add;
        }

        @Override
        public BinaryOperator<StratifiedDragstrLocusCases> combiner() {
            return StratifiedDragstrLocusCases::addAll;
        }

        @Override
        public Function<StratifiedDragstrLocusCases, StratifiedDragstrLocusCases> finisher() {
            return a -> a;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.UNORDERED);
        }
    }
}

