/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.dragstr;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.GATKTool;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.dragstr.BufferedReferenceBases;
import org.broadinstitute.hellbender.tools.dragstr.DragstrLocus;
import org.broadinstitute.hellbender.tools.dragstr.STRDecimationTable;
import org.broadinstitute.hellbender.utils.IntervalMergingRule;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.Nucleotide;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.dragstr.STRTableFileBuilder;
import picard.cmdline.programgroups.ReferenceProgramGroup;

@CommandLineProgramProperties(programGroup=ReferenceProgramGroup.class, summary="Determine the presence of STR in a reference sequence", oneLineSummary="Determines the presence of STR in a reference sequence")
public final class ComposeSTRTableFile
extends GATKTool {
    public static final String REFERENCE_SEQUENCE_BUFFER_SIZE_FULL_NAME = "reference-sequence-buffer-size";
    public static final String GENERATE_SITES_TEXT_OUTPUT_FULL_NAME = "generate-sites-text-output";
    public static final int MINIMUM_REFERENCE_SEQUENCE_BUFFER_SIZE = 1024;
    public static final int MAXIMUM_REFERENCE_SEQUENCE_BUFFER_SIZE = 100000000;
    public static final int DEFAULT_REFERENCE_SEQUENCE_BUFFER_SIZE = 100000;
    @Argument(fullName="decimation", doc="decimation per period and repeat. It can be \"DEFAULT\" to use the default values (default),  \"NONE\" to deactivate decimation (potentially resulting in a very large output file) or indicate the path to a file that contains the decimation matrix.", optional=true)
    private STRDecimationTable decimationTable = STRDecimationTable.DEFAULT;
    @Argument(doc="name of the zip file where the sites sampled will be stored", fullName="output", shortName="O")
    private GATKPath outputPath = null;
    @Argument(doc="request to generate a text formatted version of the STR table in the output zip (sites.txt)", fullName="generate-sites-text-output", optional=true)
    @Hidden
    private boolean generateSitesTextOutput = false;
    @Argument(fullName="max-period", doc="maximum STR period sampled", optional=true, minValue=1.0, maxValue=20.0)
    private int maxPeriod = 8;
    @Argument(fullName="max-repeats", doc="maximum STR repeat sampled", optional=true, minValue=1.0, maxValue=100.0)
    private int maxRepeat = 20;
    @Argument(fullName="reference-sequence-buffer-size", doc="size of the look ahead reference sequence buffer", optional=true, minValue=1024.0, maxValue=1.0E8)
    @Hidden
    private int referenceSequenceBufferSize = 100000;
    private static final String COMMAND_LINE_ANNOTATION_NAME = "commandLine";
    private File tempDir;
    private int[][][] nextMasks;

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public void onStartup() {
        super.onStartup();
        try {
            this.tempDir = File.createTempFile("gatk-sample-dragstr-sites", ".tmp");
        }
        catch (IOException ex) {
            throw new GATKException("could not create temporary disk space", ex);
        }
        if (!this.tempDir.delete()) {
            throw new GATKException("could not create temporary disk space: could not delete tempfile");
        }
        if (!this.tempDir.mkdir()) {
            throw new GATKException("could not create temporary disk space: could not create tempdir");
        }
    }

    @Override
    public void onShutdown() {
        try {
            if (this.tempDir != null) {
                FileUtils.deleteDirectory((File)this.tempDir);
            }
        }
        catch (IOException e) {
            throw new GATKException("issues removing temporary directory: " + this.tempDir, e);
        }
        finally {
            super.onShutdown();
        }
    }

    @Override
    public void traverse() {
        SAMSequenceDictionary dictionary = this.getBestAvailableSequenceDictionary();
        this.initializeMasks(dictionary);
        try (STRTableFileBuilder output = STRTableFileBuilder.newInstance(dictionary, this.decimationTable, this.generateSitesTextOutput, this.maxPeriod, this.maxRepeat);){
            output.annotate(COMMAND_LINE_ANNOTATION_NAME, this.getCommandLine());
            Map<String, List<SimpleInterval>> intervalsByContig = this.composeAndGroupTraversalIntervalsByContig(dictionary);
            for (Map.Entry<String, List<SimpleInterval>> contigEntry : intervalsByContig.entrySet()) {
                BufferedReferenceBases nucleotideSequence = BufferedReferenceBases.of(this.directlyAccessEngineReferenceDataSource(), contigEntry.getKey(), this.referenceSequenceBufferSize);
                SAMSequenceRecord sequenceRecord = dictionary.getSequence(contigEntry.getKey());
                for (SimpleInterval interval : contigEntry.getValue()) {
                    this.traverseInterval(sequenceRecord.getSequenceIndex(), nucleotideSequence, interval.getStart(), interval.getEnd(), this.decimationTable, output);
                }
            }
            output.store(this.outputPath);
        }
        this.progressMeter.stop();
    }

    private Map<String, List<SimpleInterval>> composeAndGroupTraversalIntervalsByContig(SAMSequenceDictionary dictionary) {
        if (!this.intervalArgumentCollection.intervalsSpecified()) {
            return dictionary.getSequences().stream().map(s -> new SimpleInterval(s.getSequenceName(), 1, s.getSequenceLength())).collect(Collectors.groupingBy(SimpleInterval::getContig, LinkedHashMap::new, Collectors.toList()));
        }
        Map<String, List<SimpleInterval>> keyUnsorted = IntervalUtils.sortAndMergeIntervals(this.intervalArgumentCollection.getIntervals(dictionary), dictionary, IntervalMergingRule.ALL);
        LinkedHashMap<String, List<SimpleInterval>> keySorted = new LinkedHashMap<String, List<SimpleInterval>>(keyUnsorted.size());
        keyUnsorted.entrySet().stream().sorted(Comparator.comparingInt(entry -> dictionary.getSequenceIndex((String)entry.getKey()))).forEach(entry -> {
            List cfr_ignored_0 = (List)keySorted.put((String)entry.getKey(), (List<SimpleInterval>)entry.getValue());
        });
        return keySorted;
    }

    private void initializeMasks(SAMSequenceDictionary dictionary) {
        this.nextMasks = new int[dictionary.getSequences().size()][this.maxPeriod + 1][this.maxRepeat + 1];
        for (int i = 0; i < this.nextMasks.length; ++i) {
            for (int[] masks : this.nextMasks[i]) {
                Arrays.fill(masks, i);
            }
        }
    }

    private void traverseInterval(int seqNumber, BufferedReferenceBases sequence, long seqStart, long seqEnd, STRDecimationTable decimationTable, STRTableFileBuilder output) {
        String id = sequence.contigID();
        long length = sequence.length();
        byte[] unitBuffer = new byte[this.maxPeriod];
        for (long pos = seqStart; pos <= seqEnd; ++pos) {
            BestPeriodRepeat best = this.findBestPeriodRepeatCombination(sequence, pos, length, unitBuffer);
            if (best == null) continue;
            pos = best.end;
            this.emitOrDecimateSTR(seqNumber, id, best, decimationTable, output);
        }
    }

    private BestPeriodRepeat findBestPeriodRepeatCombination(BufferedReferenceBases sequence, long pos, long length, byte[] unitBuffer) {
        BestPeriodRepeat best;
        int maxPeriodAtPos = sequence.copyBytesAt(pos, unitBuffer, 0, this.maxPeriod);
        byte firstUnitBase = unitBuffer[0];
        if (!Nucleotide.decode(firstUnitBase).isStandard()) {
            best = null;
        } else {
            long end;
            long beg;
            for (beg = pos - 1L; beg >= 1L && Nucleotide.same(sequence.byteAt(beg), firstUnitBase); --beg) {
            }
            ++beg;
            for (end = pos + 1L; end <= length && Nucleotide.same(sequence.byteAt(end), firstUnitBase); ++end) {
            }
            best = BestPeriodRepeat.initializeToOne(beg, --end);
            for (int period = 2; period <= maxPeriodAtPos && Nucleotide.decode(unitBuffer[period - 1]).isStandard(); ++period) {
                int cmp = period - 1;
                for (beg = pos - 1L; beg >= 1L && Nucleotide.same(sequence.byteAt(beg), unitBuffer[cmp]); --beg) {
                    if (--cmp != -1) continue;
                    cmp = period - 1;
                }
                ++beg;
                cmp = 0;
                for (end = pos + (long)period; end <= length && Nucleotide.same(sequence.byteAt(end), unitBuffer[cmp]); ++end) {
                    if (++cmp != period) continue;
                    cmp = 0;
                }
                best.updateIfBetter(period, beg, --end);
            }
        }
        return best;
    }

    private void emitOrDecimateSTR(int seqNumber, String seqId, BestPeriodRepeat best, STRDecimationTable decimationTable, STRTableFileBuilder output) {
        int effectiveRepeats = Math.min(this.maxRepeat, best.repeats);
        int[] nArray = this.nextMasks[seqNumber][best.period];
        int n = effectiveRepeats;
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        int mask = n2;
        if (!decimationTable.decimate(mask, best.period, best.repeats)) {
            DragstrLocus locus = DragstrLocus.make(seqNumber, best.start, (byte)best.period, (short)(best.end - best.start + 1L), mask);
            output.emit(locus);
            this.progressMeter.update(new SimpleInterval(seqId, (int)best.start, (int)best.start));
        } else {
            output.decimate(best.period, best.repeats);
        }
    }

    private static class BestPeriodRepeat {
        private int period;
        private int repeats;
        private long start;
        private long end;

        BestPeriodRepeat(int period, long start, long end) {
            this.start = start;
            this.end = end;
            this.period = period;
            this.repeats = (int)(end - start + 1L) / period;
        }

        private static BestPeriodRepeat initializeToOne(long start, long end) {
            return new BestPeriodRepeat(1, start, end);
        }

        private void updateIfBetter(int newPeriod, long newStart, long newEnd) {
            int newRepeats = (int)(newEnd - newStart + 1L) / newPeriod;
            if (newRepeats > this.repeats || newRepeats == this.repeats && newPeriod < this.period) {
                this.start = newStart;
                this.end = newEnd;
                this.period = newPeriod;
                this.repeats = newRepeats;
            }
        }
    }
}

