/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.dragstr;

import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.hellbender.utils.dragstr.DoubleSequence;

public final class DragstrHyperParameters {
    public static final int DEFAULT_MAX_PERIOD = 8;
    public static final int DEFAULT_MAX_REPEAT_LENGTH = 20;
    public static final DoubleSequence DEFAULT_PHRED_GP_VALUES = new DoubleSequence("10:1.0:50");
    public static final String GP_VALUES_ARGUMENT_FULL_NAME = "gp-values";
    public static final DoubleSequence DEFAULT_PHRED_API_VALUES = new DoubleSequence("0:1.0:40");
    public static final String API_VALUES_ARGUMENT_FULL_NAME = "api-values";
    public static final DoubleSequence DEFAULT_PHRED_GOP_VALUES = new DoubleSequence("10:.25:50");
    public static final String GOP_VALUES_ARGUMENT_FULL_NAME = "gop-values";
    public static final double DEFAULT_HET_TO_HOM_RATIO = 2.0;
    public static final String HET_TO_HOM_RATIO_FULL_NAME = "het-to-hom-ratio";
    public static final int DEFAULT_MIN_LOCI_COUNT = 50;
    public static final String MIN_LOCI_COUNT_FULL_NAME = "min-loci-count";
    public static final int DEFAULT_API_MONO_THRESHOLD = 3;
    public static final String API_MONO_THRESHOLD_FULL_NAME = "api-mono-threshold";
    public static final String MAX_PERIOD_ARGUMENT_FULL_NAME = "max-period";
    public static final String MAX_REPEATS_ARGUMENT_FULL_NAME = "max-repeats";
    public static final int DEFAULT_MIN_DEPTH = 10;
    public static final String MIN_DEPTH_ARGUMENT_SHORT_NAME = "md";
    public static final String MIN_DEPTH_ARGUMENT_FULL_NAME = "minimum-depth";
    public static final int DEFAULT_SAMPLING_PADDING = 5;
    public static final String SAMPLING_PADDING_ARGUMENT_FULL_NAME = "pileup-padding";
    public static final int DEFAULT_SAMPLING_MIN_MQ = 20;
    public static final String SAMPLING_MIN_MQ_ARGUMENT_FULL_NAME = "sampling-min-mq";
    @Argument(doc="Possible Gap-Penalty values for the DRAGstr model parameter esimation. These are expressed in Phred scaled values with the following format: start:step:end. For example the default '10:1.0:50' indicate the sequence starting at 10 finishing at 50 sampled at 1.0 intervals.", optional=true, fullName="gp-values")
    DoubleSequence phredGpValues = DEFAULT_PHRED_GP_VALUES;
    @Argument(doc="Possible prior probabilities for the heterozygous indel call for the DRAGstr model parameter esimation. These are expressed in Phred scaled values with the following format: start:step:end. For example the default '10:1.0:50' indicate the sequence starting at 10 finishing at 50 sampled at 1.0 intervals.", optional=true, fullName="api-values")
    DoubleSequence phredApiValues = DEFAULT_PHRED_API_VALUES;
    @Argument(doc="Possible values for the gop parmeterThese are expressed in Phred scaled values with the following format: start:step:end. For example the default '10:1.0:50' indicate the sequence starting at 10 finishing at 50 sampled at 1.0 intervals.", optional=true, fullName="gop-values")
    DoubleSequence phredGopValues = DEFAULT_PHRED_GOP_VALUES;
    @Argument(doc="Possible prior probabilities for the heterozygous indel call for the DRAGstr model parameter esimation. These are expressed in Phred scaled values with the following format: start:step:end. For example the default '10:1.0:50' indicate the sequence starting at 10 finishing at 50 sampled at 1.0 intervals.", optional=true, fullName="het-to-hom-ratio", minValue=0.0, maxValue=1.7976931348623157E308)
    double hetToHomRatio = 2.0;
    @Argument(doc="Minimum number of sites for a repeat count and period length pair. The estimation will combine pairs that have a smaller number of such cases (same period but +/- 1 repeat count)", optional=true, fullName="min-loci-count", minValue=1.0)
    int minLociCount = 50;
    @Argument(doc="Maximum drop allowed in the API parameter within a period between consecutive repeat length values in Phred scale", optional=true, fullName="api-mono-threshold", minValue=0.0)
    int apiMonothresh = 3;
    @Argument(fullName="max-period", doc="maximum period considered in STR analysis", optional=true, minValue=2.0, maxValue=10.0)
    public int maxPeriod = 8;
    @Argument(fullName="max-repeats", doc="maximum repeat length (in repeated units) considered in STR analyses", optional=true, minValue=2.0, maxValue=100.0)
    public int maxRepeatLength = 20;
    @Argument(fullName="minimum-depth", shortName="md", doc="Minimum coverage to consider a locus for sampling", optional=true)
    public int minDepth = 10;
    @Argument(fullName="pileup-padding", doc="bases on either side of the repeat that are included in the STR pileup", optional=true)
    public int strPadding = 5;
    @Argument(fullName="sampling-min-mq", doc="the minimum read mapping quality allowed in sampled loci. Any read with a lower MQ will result in discarding that locus", optional=true)
    public int minMQ = 20;

    public void validate() {
        if (this.phredGpValues != DEFAULT_PHRED_GP_VALUES) {
            for (double d : this.phredGpValues.toDoubleArray()) {
                if (Double.isFinite(d) && !(d < 0.0)) continue;
                throw new CommandLineException.BadArgumentValue(GP_VALUES_ARGUMENT_FULL_NAME, "Not a valid Phred value: " + d);
            }
        } else if (this.phredApiValues != DEFAULT_PHRED_API_VALUES) {
            for (double d : this.phredApiValues.toDoubleArray()) {
                if (Double.isFinite(d) && !(d < 0.0)) continue;
                throw new CommandLineException.BadArgumentValue(API_VALUES_ARGUMENT_FULL_NAME, "Not a valid Phred value: " + d);
            }
        } else {
            if (!Double.isFinite(this.hetToHomRatio) || this.hetToHomRatio <= 0.0) {
                throw new CommandLineException.BadArgumentValue(HET_TO_HOM_RATIO_FULL_NAME, "must be finite and greater than 0 but found " + this.hetToHomRatio);
            }
            if (this.minLociCount < 1) {
                throw new CommandLineException.BadArgumentValue(MIN_LOCI_COUNT_FULL_NAME, "must be greater than 0 but found " + this.minLociCount);
            }
        }
    }
}

