/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.dragstr;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import java.io.DataOutput;
import java.io.IOException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public class DragstrLocus
implements Comparable<DragstrLocus> {
    private final int chromosomeIndex;
    private final long start;
    private final byte period;
    private final short length;
    private final long mask;

    private DragstrLocus(int chrIdx, long start, byte period, short length, long mask) {
        this.chromosomeIndex = chrIdx;
        this.start = start;
        this.period = period;
        this.length = length;
        this.mask = mask;
    }

    public static DragstrLocus make(int chrIdx, long start, byte period, short length, long mask) {
        ParamUtils.isPositiveOrZero(chrIdx, "chromosome index");
        ParamUtils.isPositive(start, "start position");
        ParamUtils.isPositive(period, "period");
        ParamUtils.isPositive(length, "length");
        return new DragstrLocus(chrIdx, start, period, length, mask);
    }

    public int getChromosomeIndex() {
        return this.chromosomeIndex;
    }

    public long getMask() {
        return this.mask;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.start + (long)this.length - 1L;
    }

    public short getLength() {
        return this.length;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getRepeats() {
        return this.period == 0 ? 0 : this.length / this.period;
    }

    @Override
    public int compareTo(DragstrLocus other) {
        if (other == this) {
            return 0;
        }
        if (other == null) {
            return 1;
        }
        int cmp = Integer.compare(this.chromosomeIndex, other.chromosomeIndex);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Long.compare(this.start, other.start);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(this.length, other.length);
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(this.period, other.period);
    }

    public boolean equals(Object other) {
        return other instanceof DragstrLocus && this.compareTo((DragstrLocus)other) == 0;
    }

    public int hashCode() {
        return (this.chromosomeIndex * 31 + (int)this.start) * 47;
    }

    public SimpleInterval getStartInterval(SAMSequenceDictionary dictionary, int margin) {
        if (margin == 0) {
            return new SimpleInterval(dictionary.getSequence(this.chromosomeIndex).getSequenceName(), (int)this.start, (int)this.start);
        }
        SAMSequenceRecord record = dictionary.getSequence(this.chromosomeIndex);
        int start = Math.max(1, (int)this.start - margin);
        int end = Math.min(record.getSequenceLength(), (int)this.start + margin);
        return new SimpleInterval(record.getSequenceName(), start, end);
    }

    @FunctionalInterface
    public static interface WriteAction {
        public void write(DragstrLocus var1, DataOutput var2) throws IOException;
    }
}

