/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.dragstr;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import org.broadinstitute.hellbender.tools.dragstr.DragstrLocus;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public final class DragstrLocusCase {
    private final DragstrLocus locus;
    private final int depth;
    private final int indels;
    private final int minMQ;
    private final int nSup;

    public DragstrLocus getLocus() {
        return this.locus;
    }

    public int getPeriod() {
        return this.locus.getPeriod();
    }

    public int getRepeatLength() {
        return this.locus.getRepeats();
    }

    public int getDepth() {
        return this.depth;
    }

    public int getIndels() {
        return this.indels;
    }

    public int getMinMQ() {
        return this.minMQ;
    }

    public int getNSup() {
        return this.nSup;
    }

    public static DragstrLocusCase create(DragstrLocus locus, int depth, int indels, int minMQ, int nSup) {
        Utils.nonNull(locus);
        Utils.validateArg(depth >= 0, "depth must be 0 or positive");
        Utils.validateArg(indels >= 0, "the non-ref indel count must be 0 or positive");
        Utils.validateArg(minMQ >= 0, "the min-MQ must be 0 or positive");
        Utils.validateArg(nSup >= 0, "the number of supplementaries must 0 or positive");
        return new DragstrLocusCase(locus, depth, indels, minMQ, nSup);
    }

    public DragstrLocusCase(DragstrLocus locus, int total, int nonRef, int minMQ, int nSup) {
        this.locus = locus;
        this.depth = total;
        this.indels = nonRef;
        this.minMQ = minMQ;
        this.nSup = nSup;
    }

    public boolean qualifies(int minDepth, int samplingMinMQ, int maxSup) {
        return this.depth >= minDepth && this.nSup <= maxSup && this.minMQ >= samplingMinMQ;
    }

    public Locatable getLocation(SAMSequenceDictionary dictionary) {
        return new SimpleInterval(dictionary.getSequence(this.locus.getChromosomeIndex()).getSequenceName(), (int)this.locus.getStart(), (int)this.locus.getEnd());
    }
}

