/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.dragstr;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.dragstr.DragstrLocusCase;
import org.broadinstitute.hellbender.utils.Utils;

public final class DragstrLocusCases
extends AbstractList<DragstrLocusCase> {
    private final List<DragstrLocusCase> cases;
    private final int period;
    private final int repeatLength;

    public DragstrLocusCases(int period, int repeatLength) {
        this(100, period, repeatLength);
    }

    @Override
    public DragstrLocusCase get(int index) {
        return this.cases.get(index);
    }

    public DragstrLocusCases(int initialCapacity, int period, int repeatLength) {
        Utils.validateArg(initialCapacity >= 0, "the initial capacity must be 0 or greater");
        Utils.validateArg(period >= 1, "the period cannot be less than 1");
        Utils.validateArg(repeatLength >= 1, "the repeat-length cannot be less than 1");
        this.period = period;
        this.repeatLength = repeatLength;
        this.cases = new ArrayList<DragstrLocusCase>(initialCapacity);
    }

    private DragstrLocusCases(int period, int repeatLength, List<DragstrLocusCase> cases) {
        this.period = period;
        this.repeatLength = repeatLength;
        this.cases = cases;
    }

    @Override
    public boolean add(DragstrLocusCase caze) {
        Utils.validateArg(caze.getPeriod() == this.period, "the input case has the wrong period");
        Utils.validateArg(caze.getRepeatLength() >= this.repeatLength, "the input case has a repeat-length smaller than this collections");
        return this.cases.add(caze);
    }

    @Override
    public boolean addAll(Collection<? extends DragstrLocusCase> more) {
        for (DragstrLocusCase dragstrLocusCase : more) {
            this.add(dragstrLocusCase);
        }
        return true;
    }

    public boolean addAll(DragstrLocusCases other) {
        return this.addAll((Collection<? extends DragstrLocusCase>)other.cases);
    }

    public int getPeriod() {
        return this.period;
    }

    public int getRepeatLength() {
        return this.repeatLength;
    }

    @Override
    public int size() {
        return this.cases.size();
    }

    public DragstrLocusCases qualifyingOnly(int minDepth, int minMQ, int maxSup) {
        List<DragstrLocusCase> newCases = this.cases.stream().filter(caze -> caze.getDepth() >= minDepth && caze.getMinMQ() >= minMQ && caze.getNSup() <= maxSup).collect(Collectors.toList());
        return new DragstrLocusCases(this.period, this.repeatLength, newCases);
    }
}

