/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.dragstr;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import it.unimi.dsi.fastutil.ints.Int2LongArrayMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.IOUtils;
import org.broadinstitute.hellbender.tools.dragstr.DragstrLocus;
import org.broadinstitute.hellbender.utils.BinaryTableReader;
import org.broadinstitute.hellbender.utils.BinaryTableWriter;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableReader;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public class DragstrLocusUtils {
    private static final int INDEX_BYTE_INTERVAL = 65536;

    private static BinaryTableWriter<DragstrLocus> binaryWriter(OutputStream out, OutputStream indexOut, String path) {
        return DragstrLocusUtils.binaryWriter(out, indexOut, path, (record, output) -> {
            output.writeInt(record.getChromosomeIndex());
            output.writeLong(record.getStart());
            output.writeByte(record.getPeriod());
            output.writeShort(record.getLength());
            output.writeLong(record.getMask());
        });
    }

    public static BinaryTableWriter<DragstrLocus> dragenWriter(OutputStream out, OutputStream indexOut, String path) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return DragstrLocusUtils.binaryWriter(out, indexOut, path, (record, output) -> {
            buffer.clear();
            buffer.putInt((int)record.getMask());
            buffer.putInt(record.getChromosomeIndex());
            buffer.putInt((int)record.getStart() - 1);
            buffer.putShort(record.getLength());
            buffer.put((byte)record.getPeriod());
            buffer.put((byte)Math.min(8, record.getRepeats()));
            output.write(buffer.array());
        });
    }

    private static BinaryTableWriter<DragstrLocus> binaryWriter(OutputStream out, final OutputStream indexOut, String path, final DragstrLocus.WriteAction wa) {
        return new BinaryTableWriter<DragstrLocus>(out, path){
            private DataOutputStream indexDataOutputStream;
            private Int2LongMap chromosomeOffsets;
            private int lastChromosomeIndex;
            private long lastEntryOffset;
            {
                super(out, path);
                this.indexDataOutputStream = indexOut != null ? new DataOutputStream(indexOut) : null;
                this.chromosomeOffsets = new Int2LongArrayMap();
                this.lastChromosomeIndex = -1;
                this.lastEntryOffset = 0L;
            }

            @Override
            protected void writeRecord(DragstrLocus record, DataOutput output) throws IOException {
                if (indexOut != null) {
                    this.outputIndexWhenApplies(record);
                }
                wa.write(record, output);
            }

            private void outputIndexWhenApplies(DragstrLocus record) throws IOException {
                long offset = this.offset();
                if (this.lastChromosomeIndex != record.getChromosomeIndex()) {
                    if (this.chromosomeOffsets.containsKey(record.getChromosomeIndex())) {
                        throw new IllegalStateException("cannot index the output when not sorted; chromosome index " + record.getChromosomeIndex() + " appears in more than one piece ");
                    }
                    this.dataOut.flush();
                    this.lastChromosomeIndex = record.getChromosomeIndex();
                    this.chromosomeOffsets.put(this.lastChromosomeIndex, offset);
                    this.indexDataOutputStream.writeInt(this.lastChromosomeIndex);
                    this.indexDataOutputStream.writeInt((int)record.getStart());
                    this.indexDataOutputStream.writeLong(offset);
                    this.lastEntryOffset = offset;
                } else if (offset - this.lastEntryOffset >= 65536L) {
                    this.dataOut.flush();
                    this.indexDataOutputStream.writeInt(this.lastChromosomeIndex);
                    this.indexDataOutputStream.writeInt((int)record.getStart());
                    this.indexDataOutputStream.writeLong(offset);
                    this.lastEntryOffset = offset;
                }
            }

            @Override
            public void close() throws IOException {
                super.close();
                if (indexOut != null) {
                    this.indexDataOutputStream.close();
                }
            }
        };
    }

    public static BinaryTableWriter<DragstrLocus> binaryWriter(File out) throws FileNotFoundException {
        return DragstrLocusUtils.binaryWriter(out, null);
    }

    public static BinaryTableWriter<DragstrLocus> binaryWriter(File out, File indexFile) throws FileNotFoundException {
        return DragstrLocusUtils.binaryWriter(new FileOutputStream(out), indexFile != null ? new FileOutputStream(indexFile) : new IOUtils.NullOutputStream(), out.toString());
    }

    public static BinaryTableReader<DragstrLocus> binaryReader(File file) throws FileNotFoundException {
        return DragstrLocusUtils.binaryReader(new FileInputStream(file));
    }

    public static BinaryTableReader<DragstrLocus> binaryReader(InputStream in) {
        return new BinaryTableReader<DragstrLocus>(in, null){

            @Override
            protected DragstrLocus readRecord(DataInput input) throws IOException {
                int chrIdx = input.readInt();
                long start = input.readLong();
                byte period = input.readByte();
                short length = input.readShort();
                long mask = input.readLong();
                return DragstrLocus.make(chrIdx, start, period, length, mask);
            }
        };
    }

    public static BinaryTableReader<DragstrLocus> binaryReader(String path, BinaryTableIndex index, final int chrIdx, final int start, final int end) throws IOException {
        long offset = index.offset(chrIdx, start, end);
        if (offset < 0L) {
            return BinaryTableReader.emptyReader();
        }
        InputStream in = BucketUtils.openFile(path);
        if (in.skip(offset) != offset) {
            throw new IOException("failed to skip the requested number of bytes");
        }
        return new BinaryTableReader<DragstrLocus>(in, null){

            @Override
            protected DragstrLocus readRecord(DataInput input) throws IOException {
                long m;
                short l;
                byte p;
                int c;
                long s;
                do {
                    c = input.readInt();
                    s = input.readLong();
                    p = input.readByte();
                    l = input.readShort();
                    m = input.readLong();
                    if (chrIdx != c) {
                        return null;
                    }
                    if (s <= (long)end) continue;
                    return null;
                } while (s < (long)start);
                return DragstrLocus.make(c, s, p, l, m);
            }
        };
    }

    public static TableWriter<DragstrLocus> textWriter(OutputStream out, final SAMSequenceDictionary dictionary) throws IOException {
        return new TableWriter<DragstrLocus>((Writer)new OutputStreamWriter(out), TableColumnCollection.make("chridx", "chrid", "start", "end", "period", "mask", "mask_bin", "length_bp", "length_rp")){

            @Override
            protected void composeLine(DragstrLocus record, DataLine dataLine) {
                dataLine.append(record.getChromosomeIndex()).append(dictionary.getSequence(record.getChromosomeIndex()).getSequenceName()).append(record.getStart()).append(record.getStart() + (long)record.getLength() - 1L).append(record.getPeriod()).append(record.getMask()).append(Long.toBinaryString(record.getMask())).append((int)record.getLength()).append(record.getLength() / record.getPeriod());
            }
        };
    }

    static TableReader<DragstrLocus> textReader(InputStream in, final SAMSequenceDictionary dictionary) throws IOException {
        return new TableReader<DragstrLocus>((Reader)new InputStreamReader(in)){

            @Override
            protected DragstrLocus createRecord(DataLine dataLine) {
                String chr = dataLine.get("chrid");
                SAMSequenceRecord seq = dictionary.getSequence(chr);
                int chridx = seq.getSequenceIndex();
                long start = dataLine.getLong("start");
                byte period = dataLine.getByte("period");
                short length = (short)dataLine.getInt("length");
                int mask = dataLine.getInt("mask");
                return DragstrLocus.make(chridx, start, period, length, mask);
            }
        };
    }

    public static class BinaryTableIndex {
        private Int2ObjectMap<List<Entry>> entriesByChrIdx;

        private BinaryTableIndex(Int2ObjectMap<List<Entry>> entries) {
            this.entriesByChrIdx = entries;
        }

        public long offset(int chrIdx, int start, int end) {
            List chrEntries = (List)this.entriesByChrIdx.get(chrIdx);
            if (chrEntries == null || chrEntries.isEmpty()) {
                return -1L;
            }
            if (((Entry)chrEntries.get((int)0)).pos > end) {
                return -1L;
            }
            int i = 0;
            int j = chrEntries.size() - 1;
            while (i < j) {
                int k = (i + j) / 2;
                Entry candidate = (Entry)chrEntries.get(k);
                if (candidate.pos < start) {
                    i = Math.min(k + 1, j);
                    continue;
                }
                if (candidate.pos > start) {
                    j = Math.max(k - 1, i);
                    continue;
                }
                return candidate.offset;
            }
            while (i > 0 && ((Entry)chrEntries.get((int)i)).pos > start) {
                --i;
            }
            return ((Entry)chrEntries.get((int)i)).offset;
        }

        public static BinaryTableIndex load(String path) {
            return BinaryTableIndex.load(BucketUtils.openFile(path));
        }

        public static BinaryTableIndex load(InputStream inputStream) {
            BinaryTableReader<Entry> entryReader = new BinaryTableReader<Entry>(inputStream, null){

                @Override
                protected Entry readRecord(DataInput input) throws IOException {
                    int chrIdx = input.readInt();
                    int pos = input.readInt();
                    long offset = input.readLong();
                    return Entry.of(chrIdx, pos, offset);
                }
            };
            Int2ObjectArrayMap entriesByChrIdx = new Int2ObjectArrayMap();
            entryReader.stream().forEach(arg_0 -> BinaryTableIndex.lambda$load$0((Int2ObjectMap)entriesByChrIdx, arg_0));
            return new BinaryTableIndex((Int2ObjectMap<List<Entry>>)entriesByChrIdx);
        }

        private static /* synthetic */ void lambda$load$0(Int2ObjectMap entriesByChrIdx, Entry entry) {
            ArrayList<Entry> entries = (ArrayList<Entry>)entriesByChrIdx.get(entry.chrIdx);
            if (entries == null) {
                entries = new ArrayList<Entry>();
                entriesByChrIdx.put(entry.chrIdx, entries);
            }
            entries.add(entry);
        }

        private static class Entry {
            public final int chrIdx;
            public final int pos;
            public final long offset;

            private Entry(int chrIdx, int pos, long offset) {
                this.chrIdx = chrIdx;
                this.pos = pos;
                this.offset = offset;
            }

            public static Entry of(int chrIdx, int pos, long offset) {
                return new Entry(chrIdx, pos, offset);
            }
        }
    }
}

