/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.dragstr;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.commons.lang.math.IntRange;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.dragstr.DragstrHyperParameters;
import org.broadinstitute.hellbender.tools.dragstr.DragstrLocusCase;
import org.broadinstitute.hellbender.tools.dragstr.DragstrLocusCases;
import org.broadinstitute.hellbender.tools.dragstr.StratifiedDragstrLocusCases;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParams;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParamsBuilder;

final class DragstrParametersEstimator {
    private final DragstrHyperParameters hyperParameters;
    private final double[] phredGpValues;
    private final double[] phredApiValues;
    private final double[] log10GpValues;
    private final double[] log10ApiValues;
    private final double hetOverHomVar;
    private final double log10HetOverHomVar;
    private final int[] minGpIndexByPeriod;
    private final double[][][] log10PErrorByLength;
    private final double[][][] log10PCorrectByLength;

    DragstrParametersEstimator(DragstrHyperParameters argumentCollection) {
        int i;
        this.hyperParameters = argumentCollection;
        this.phredGpValues = argumentCollection.phredGpValues.toDoubleArray();
        this.phredApiValues = argumentCollection.phredApiValues.toDoubleArray();
        this.log10GpValues = MathUtils.applyToArray(this.phredGpValues, d -> -0.1 * d);
        this.log10ApiValues = MathUtils.applyToArray(this.phredApiValues, d -> -0.1 * d);
        this.hetOverHomVar = argumentCollection.hetToHomRatio;
        this.log10HetOverHomVar = Math.log10(this.hetOverHomVar);
        this.log10PErrorByLength = new double[this.phredGpValues.length][this.hyperParameters.maxPeriod][this.hyperParameters.maxRepeatLength];
        this.log10PCorrectByLength = new double[this.phredGpValues.length][this.hyperParameters.maxPeriod][this.hyperParameters.maxRepeatLength];
        this.minGpIndexByPeriod = new int[this.hyperParameters.maxPeriod];
        for (i = 0; i < this.phredGpValues.length; ++i) {
            for (int k = 0; k < this.hyperParameters.maxPeriod; ++k) {
                int period = k + 1;
                double log10PCorrectPerPosition = MathUtils.log10OneMinusPow10(-MathUtils.LOG10_ONE_HALF + this.log10GpValues[i]);
                for (int j = 0; j < this.hyperParameters.maxRepeatLength; ++j) {
                    int repeats = j + 1;
                    int lengthInBases = repeats * period;
                    this.log10PCorrectByLength[i][k][j] = (double)lengthInBases * log10PCorrectPerPosition;
                    this.log10PErrorByLength[i][k][j] = MathUtils.log10OneMinusPow10(this.log10PCorrectByLength[i][k][j]);
                }
            }
        }
        for (i = 0; i < this.minGpIndexByPeriod.length; ++i) {
            int period = i + 1;
            double gpMin = Math.ceil(-10.0 * Math.log10(1.0 - Math.pow(0.5, 1.0 / (double)(this.hyperParameters.maxRepeatLength * period) / 2.0)));
            int index = Arrays.binarySearch(this.phredGpValues, gpMin);
            this.minGpIndexByPeriod[i] = index >= 0 ? index : (index < -1 && Math.abs(gpMin - this.phredApiValues[-index - 2]) < 0.001 ? -index - 2 : -index - 1);
        }
    }

    public DragstrParams estimate(StratifiedDragstrLocusCases cases) {
        DragstrParamsBuilder builder = new DragstrParamsBuilder(this.hyperParameters.maxPeriod, this.hyperParameters.maxRepeatLength);
        IntStream.range(1, this.hyperParameters.maxPeriod + 1).parallel().forEach(period -> this.estimatePeriod(period, builder, cases));
        return builder.make(this.hyperParameters.phredGopValues);
    }

    private void estimatePeriod(int period, DragstrParamsBuilder destination, StratifiedDragstrLocusCases cases) {
        int accum = 0;
        int leftFlank = 0;
        while (leftFlank < this.hyperParameters.maxRepeatLength && (accum += cases.get(period, ++leftFlank).size()) < this.hyperParameters.minLociCount) {
        }
        accum = 0;
        int rightFlank = this.hyperParameters.maxRepeatLength;
        while (rightFlank > 0 && (accum += cases.get(period, --rightFlank).size()) < this.hyperParameters.minLociCount) {
        }
        if (rightFlank < leftFlank) {
            throw new UserException.BadInput("not enough cases for period " + period);
        }
        ArrayDeque<IntRange> pending = new ArrayDeque<IntRange>(this.hyperParameters.maxRepeatLength);
        pending.add(new IntRange(1, leftFlank));
        ++leftFlank;
        while (leftFlank <= rightFlank) {
            pending.add(new IntRange(leftFlank));
            ++leftFlank;
        }
        pending.add(new IntRange(++rightFlank, this.hyperParameters.maxRepeatLength));
        IntRange last = null;
        ArrayDeque<IntRange> done = new ArrayDeque<IntRange>(this.hyperParameters.maxRepeatLength);
        do {
            IntRange next = (IntRange)pending.pop();
            this.estimatePeriodRepeatInterval(period, next, destination, cases);
            double gp1 = destination.gp(period, next.getMinimumInteger());
            double api1 = destination.api(period, next.getMinimumInteger());
            if (last == null || destination.gp(period, last.getMaximumInteger()) >= gp1 && destination.api(period, last.getMaximumInteger()) + (double)this.hyperParameters.apiMonothresh >= api1) {
                last = next;
                done.addLast(last);
                continue;
            }
            pending.push(new IntRange(last.getMinimumNumber(), next.getMaximumNumber()));
            done.removeLast();
            IntRange intRange = last = !done.isEmpty() ? (IntRange)done.getLast() : null;
        } while (!pending.isEmpty());
    }

    private void estimatePeriodRepeatInterval(int period, IntRange repeatRange, DragstrParamsBuilder builder, StratifiedDragstrLocusCases cases) {
        int maxApiIdx = -1;
        int maxGpIdx = -1;
        double maxLog10Prob = Double.NEGATIVE_INFINITY;
        int minRepeat = repeatRange.getMinimumInteger();
        int maxRepeat = repeatRange.getMaximumInteger();
        int periodIdx = period - 1;
        double maxLog10PHet = this.log10HetOverHomVar - Math.log10(1.0 + this.hyperParameters.hetToHomRatio);
        for (int i = 0; i < this.log10ApiValues.length; ++i) {
            double log10PHet = Math.min(this.log10ApiValues[i], maxLog10PHet);
            double log10PHomVar = log10PHet - this.log10HetOverHomVar;
            double log10PHomRef = MathUtils.log10OneMinusPow10(MathUtils.log10SumLog10(log10PHet, log10PHomVar));
            block1: for (int j = this.minGpIndexByPeriod[periodIdx]; j < this.phredGpValues.length; ++j) {
                double log10ProbAccumulator = 0.0;
                int r = minRepeat;
                int repeatIdx = r - 1;
                while (r <= maxRepeat) {
                    DragstrLocusCases repeatCases = cases.get(period, r);
                    double log10PError = this.log10PErrorByLength[j][periodIdx][repeatIdx];
                    double log10PCorrect = this.log10PCorrectByLength[j][periodIdx][repeatIdx];
                    for (DragstrLocusCase caze : repeatCases) {
                        double d;
                        log10ProbAccumulator += this.log10ProbFunc(caze.getDepth(), caze.getIndels(), log10PError, log10PCorrect, log10PHomRef, log10PHet, log10PHomVar);
                        if (!(d < maxLog10Prob)) continue;
                        continue block1;
                    }
                    ++r;
                    ++repeatIdx;
                }
                if (!(log10ProbAccumulator > maxLog10Prob)) continue;
                maxApiIdx = i;
                maxGpIdx = j;
                maxLog10Prob = log10ProbAccumulator;
            }
        }
        builder.set(period, repeatRange, this.phredGpValues[maxGpIdx], 10.0 / (double)period, this.phredApiValues[maxApiIdx]);
    }

    private double log10ProbFunc(int n, int k, double log10PError, double log10PCorrect, double log10PHomRef, double log10PHet, double log10PHomVar) {
        return MathUtils.log10SumLog10(log10PHomRef + (double)k * log10PError + (double)(n - k) * log10PCorrect, log10PHet + (double)n * MathUtils.LOG10_ONE_HALF, n == k ? log10PHomVar : Double.NEGATIVE_INFINITY);
    }
}

