/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.dragstr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;

public class STRDecimationTable {
    private static final int[][] DEFAULT_DECIMATION_MATRIX = new int[][]{{0}, {0, 10, 10, 9, 8, 7, 5, 3, 1, 0}, {0, 0, 9, 6, 3, 0}, {0, 0, 8, 4, 1, 0}, {0, 0, 6, 0}, {0, 0, 5, 0}, {0, 0, 4, 0}, {0, 0, 1, 0}, {0}};
    public static final String NO_DECIMATION_STR = "NONE";
    public static final String DEFAULT_DECIMATION_STR = "DEFAULT";
    public static final STRDecimationTable DEFAULT = new STRDecimationTable("DEFAULT");
    public static final STRDecimationTable NONE = new STRDecimationTable("NONE");
    private final String description;
    private final int[][] decimationMatrix;
    private final long[][] decimationMask;
    private final long[][] counts;

    public STRDecimationTable(String spec) {
        Utils.nonNull(spec);
        this.decimationMatrix = spec.equalsIgnoreCase(NO_DECIMATION_STR) ? (Object)new int[][]{{0}} : (spec.equalsIgnoreCase(DEFAULT_DECIMATION_STR) ? DEFAULT_DECIMATION_MATRIX : STRDecimationTable.parseDecimationMatrixFromPath(spec));
        this.description = spec;
        this.decimationMask = STRDecimationTable.calculateDecimationMask(this.decimationMatrix);
        this.counts = this.composeDecimationCounts(this.decimationMask);
    }

    private long[][] composeDecimationCounts(long[][] decimationMask) {
        long[][] result = new long[decimationMask.length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new long[decimationMask[i].length];
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int[][] parseDecimationMatrixFromPath(String spec) {
        try (BufferedReader reader = new BufferedReader(IOUtils.makeReaderMaybeGzipped(Paths.get(spec, new String[0])));){
            String[][] values = (String[][])reader.lines().filter(str -> !str.startsWith("#") && !str.trim().isEmpty()).map(str -> (String[])Arrays.stream(str.split("\\s+")).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
            int[][] nArray = STRDecimationTable.coerceStringMatrix(values, spec);
            return nArray;
        }
        catch (IOException ex) {
            throw new UserException.CouldNotReadInputFile(spec, (Exception)ex);
        }
        catch (NumberFormatException ex) {
            throw new UserException.BadInput(String.format("input decimation file %s contains non-valid values: %s", spec, ex.getMessage()));
        }
    }

    public void print(PrintWriter writer) {
        Utils.nonNull(writer);
        for (int[] row : this.decimationMatrix) {
            writer.println(Utils.join("\t", row));
        }
        writer.flush();
    }

    private static int[][] coerceStringMatrix(String[][] values, String path) {
        Utils.nonNull(values);
        if (values.length == 0) {
            LogManager.getLogger(STRDecimationTable.class).warn("Decimation matrix path provided does not seem to contain any values, we will proceed without any decimation");
            return new int[0][];
        }
        int totalValues = 0;
        int[][] result = new int[values.length][];
        for (int i = 0; i < values.length; ++i) {
            String[] row = values[i];
            int[] rowValues = new int[values[i].length];
            for (int j = 0; j < row.length; ++j) {
                int value;
                String str = row[j];
                try {
                    value = Integer.parseInt(str);
                }
                catch (NumberFormatException ex) {
                    throw STRDecimationTable.badDecimationValueException(str, path, i, j, "not a valid double literal");
                }
                if (value < 0) {
                    throw STRDecimationTable.badDecimationValueException(str, path, i, j, "negatives are not allowed");
                }
                if (Double.isNaN(value)) {
                    throw STRDecimationTable.badDecimationValueException(str, path, i, j, "NaN are not allowed");
                }
                if (!Double.isFinite(value)) {
                    throw STRDecimationTable.badDecimationValueException(str, path, i, j, "must be finite");
                }
                rowValues[j] = value;
                ++totalValues;
            }
            result[i] = rowValues;
        }
        if (totalValues == 0) {
            throw new UserException.BadInput("the input decimation matrix does contain any values:" + path);
        }
        return result;
    }

    private static RuntimeException badDecimationValueException(String str, String path, int i, int j, String details) {
        throw new UserException.BadInput(String.format("bad decimation value found in %s for period and repeats (%d, %d) with string (%s)%s", path, i, j, str, details == null || details.isEmpty() ? "" : ": " + details));
    }

    private static long[][] calculateDecimationMask(int[][] decimationMatrix) {
        Utils.nonNull(decimationMatrix);
        long[][] result = new long[decimationMatrix.length][];
        for (int i = 0; i < result.length; ++i) {
            int[] row = decimationMatrix[i];
            result[i] = new long[row.length];
            for (int j = 0; j < row.length; ++j) {
                result[i][j] = (1 << row[j]) - 1;
            }
        }
        return result;
    }

    public long mask(int period, int repeats) {
        int p = period >= this.decimationMask.length ? this.decimationMask.length - 1 : period;
        long[] masks = this.decimationMask[p];
        if (masks.length == 0) {
            return 0L;
        }
        if (repeats >= masks.length) {
            return masks[masks.length - 1];
        }
        return masks[repeats];
    }

    public boolean decimate(long mask, int bestPeriod, long bestPeriodRepeats) {
        if (this.counts.length <= bestPeriod) {
            return false;
        }
        long[] periodCounts = this.counts[bestPeriod];
        if (bestPeriodRepeats >= (long)periodCounts.length) {
            return false;
        }
        long left = mask;
        long right = this.decimationMask[bestPeriod][(int)bestPeriodRepeats];
        return ((int)left & (int)right) != 0 || (left >> 32 & right >> 32) != 0L;
    }

    public int decimationBit(int period, int repeatCount) {
        if (period >= this.decimationMatrix.length) {
            return 0;
        }
        if (repeatCount >= this.decimationMatrix[period].length) {
            return 0;
        }
        return this.decimationMatrix[period][repeatCount];
    }

    public String toString() {
        return this.description;
    }
}

