/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.dragstr;

import org.broadinstitute.hellbender.tools.dragstr.DragstrLocusCase;
import org.broadinstitute.hellbender.tools.dragstr.DragstrLocusCases;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

final class StratifiedDragstrLocusCases {
    private int size;
    DragstrLocusCases[][] perPeriodAndRepeat;

    StratifiedDragstrLocusCases(int maxPeriod, int maxRepeats) {
        this.perPeriodAndRepeat = new DragstrLocusCases[maxPeriod][maxRepeats];
        for (int i = 0; i < maxPeriod; ++i) {
            for (int j = 0; j < maxRepeats; ++j) {
                this.perPeriodAndRepeat[i][j] = new DragstrLocusCases(i + 1, j + 1);
            }
        }
    }

    public static StratifiedDragstrLocusCases make(int maxPeriod, int maxRepeats) {
        ParamUtils.isPositive(maxPeriod, "max-period must be greater than 0");
        ParamUtils.isPositive(maxRepeats, "max-repeats must be greater than 0");
        return new StratifiedDragstrLocusCases(maxPeriod, maxRepeats);
    }

    public StratifiedDragstrLocusCases addAll(StratifiedDragstrLocusCases other) {
        Utils.validate(this.perPeriodAndRepeat.length == other.perPeriodAndRepeat.length, "incompatible dimensions");
        for (int i = 0; i < this.perPeriodAndRepeat.length; ++i) {
            Utils.validate(this.perPeriodAndRepeat[i].length == other.perPeriodAndRepeat[i].length, "invalid dimensions");
            for (int j = 0; j < this.perPeriodAndRepeat[i].length; ++j) {
                this.perPeriodAndRepeat[i][j].addAll(other.perPeriodAndRepeat[i][j]);
            }
        }
        this.size += other.size;
        return this;
    }

    public int size() {
        return this.size;
    }

    public static StratifiedDragstrLocusCases merge(StratifiedDragstrLocusCases ... cazes) {
        if (cazes.length == 0) {
            return new StratifiedDragstrLocusCases(8, 20);
        }
        StratifiedDragstrLocusCases result = new StratifiedDragstrLocusCases(cazes[0].perPeriodAndRepeat.length, cazes[0].perPeriodAndRepeat[0].length);
        for (StratifiedDragstrLocusCases col : cazes) {
            result.addAll(col);
        }
        return result;
    }

    public DragstrLocusCases get(int period, int repeats) {
        int periodIndex = Utils.validIndex(period - 1, this.perPeriodAndRepeat.length, "period is out of range");
        int repeatIndex = Math.min(ParamUtils.isPositive(repeats, "repeats must be greater than 0 ") - 1, this.perPeriodAndRepeat[periodIndex].length - 1);
        return this.perPeriodAndRepeat[periodIndex][repeatIndex];
    }

    public void addAll(DragstrLocusCases in) {
        int periodIndex = in.getPeriod() - 1;
        DragstrLocusCases cases = this.perPeriodAndRepeat[periodIndex][Math.min(this.perPeriodAndRepeat[periodIndex].length - 1, in.getRepeatLength() - 1)];
        cases.addAll(in);
        this.size += in.size();
    }

    public void add(DragstrLocusCase caze) {
        DragstrLocusCases cases = this.perPeriodAndRepeat[caze.getPeriod() - 1][Math.min(this.perPeriodAndRepeat[0].length - 1, caze.getRepeatLength() - 1)];
        cases.add(caze);
        ++this.size;
    }

    StratifiedDragstrLocusCases qualifyingOnly(int minDepth, int minMQ, int maxSup) {
        StratifiedDragstrLocusCases result = new StratifiedDragstrLocusCases(this.perPeriodAndRepeat.length, this.perPeriodAndRepeat[0].length);
        DragstrLocusCases[][] dragstrLocusCasesArray = this.perPeriodAndRepeat;
        int n = dragstrLocusCasesArray.length;
        for (int i = 0; i < n; ++i) {
            DragstrLocusCases[] periodCases;
            for (DragstrLocusCases cases : periodCases = dragstrLocusCasesArray[i]) {
                result.addAll(cases.qualifyingOnly(minDepth, minMQ, maxSup));
            }
        }
        return result;
    }
}

