/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.PrintStream;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.ExampleProgramGroup;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.engine.AssemblyRegionEvaluator;
import org.broadinstitute.hellbender.engine.AssemblyRegionWalker;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.activityprofile.ActivityProfileState;

@CommandLineProgramProperties(summary="Example AssemblyRegionWalker that prints out the bounds of each assembly region with and without padding, as well as the number of reads in each region", oneLineSummary="Example AssemblyRegionWalker", programGroup=ExampleProgramGroup.class, omitFromCommandLine=true)
public final class ExampleAssemblyRegionWalker
extends AssemblyRegionWalker {
    @Argument(fullName="output", shortName="O", doc="Output file (if not provided, defaults to STDOUT)", common=false, optional=true)
    private GATKPath outputFile = null;
    @Argument(fullName="knownVariants", shortName="knownVariants", doc="Known set of variants", optional=true)
    private FeatureInput<VariantContext> knownVariants;
    private PrintStream outputStream = null;

    @Override
    public AssemblyRegionEvaluator assemblyRegionEvaluator() {
        return (locusPileup, referenceContext, featureContext) -> new ActivityProfileState(new SimpleInterval(locusPileup), 1.0);
    }

    @Override
    public void onTraversalStart() {
        try {
            this.outputStream = this.outputFile != null ? new PrintStream(this.outputFile.getOutputStream()) : System.out;
        }
        catch (Exception e) {
            throw new UserException.CouldNotCreateOutputFile(this.outputFile, "Failed attempting to create an output stream", e);
        }
    }

    @Override
    public void apply(AssemblyRegion region, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.outputStream.printf("%s assembly region at %s (%s with padding), containing %d reads.\n\n", region.isActive() ? "ACTIVE" : "INACTIVE", region.getSpan(), region.getPaddedSpan(), region.getReads().size());
        this.printReferenceBases(referenceContext);
        if (featureContext.hasBackingDataSource()) {
            this.printOverlappingVariants(featureContext);
        }
    }

    private void printReferenceBases(ReferenceContext refContext) {
        this.outputStream.printf("\tOverlapping reference bases: %s\n\n", new String(refContext.getBases()));
    }

    private void printOverlappingVariants(FeatureContext featureContext) {
        for (VariantContext variant : featureContext.getValues(this.knownVariants)) {
            this.outputStream.printf("\tOverlapping variant at %s:%d-%d. Ref: %s Alt(s): %s\n\n", variant.getContig(), variant.getStart(), variant.getEnd(), variant.getReference(), variant.getAlternateAlleles());
        }
        this.outputStream.println();
    }

    @Override
    public void closeTool() {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

