/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.ExampleProgramGroup;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.engine.AssemblyRegionEvaluator;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionWalkerContext;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionWalkerSpark;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.activityprofile.ActivityProfileState;

@CommandLineProgramProperties(summary="Example AssemblyRegionWalker that prints out the bounds of each assembly region with and without padding, as well as the number of reads in each region", oneLineSummary="Example AssemblyRegionWalker", programGroup=ExampleProgramGroup.class, omitFromCommandLine=true)
public final class ExampleAssemblyRegionWalkerSpark
extends AssemblyRegionWalkerSpark {
    private static final long serialVersionUID = 1L;
    @Argument(doc="the output file path", shortName="O", fullName="output", optional=false)
    protected String outputFile;
    @Argument(fullName="knownVariants", shortName="knownVariants", doc="Known set of variants", optional=true)
    private FeatureInput<VariantContext> knownVariants;

    @Override
    public AssemblyRegionEvaluator assemblyRegionEvaluator() {
        return new ARE();
    }

    @Override
    protected void processAssemblyRegions(JavaRDD<AssemblyRegionWalkerContext> rdd, JavaSparkContext ctx) {
        rdd.map(ExampleAssemblyRegionWalkerSpark.assemblyFunction(this.knownVariants)).saveAsTextFile(this.outputFile);
    }

    private static Function<AssemblyRegionWalkerContext, String> assemblyFunction(FeatureInput<VariantContext> knownVariants) {
        return (Function & Serializable)context -> {
            AssemblyRegion region = context.getAssemblyRegion();
            ReferenceContext referenceContext = context.getReferenceContext();
            FeatureContext featureContext = context.getFeatureContext();
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%s assembly region at %s (%s with padding), containing %d reads.\n\n", region.isActive() ? "ACTIVE" : "INACTIVE", region.getSpan(), region.getPaddedSpan(), region.getReads().size()));
            sb.append(String.format("\tOverlapping reference bases: %s\n\n", new String(referenceContext.getBases())));
            if (featureContext.hasBackingDataSource()) {
                for (VariantContext variant : featureContext.getValues(knownVariants)) {
                    sb.append(String.format("\tOverlapping variant at %s:%d-%d. Ref: %s Alt(s): %s\n\n", variant.getContig(), variant.getStart(), variant.getEnd(), variant.getReference(), variant.getAlternateAlleles()));
                }
            }
            return sb.toString();
        };
    }

    static class ARE
    implements AssemblyRegionEvaluator,
    Serializable {
        private static final long serialVersionUID = 1L;

        ARE() {
        }

        @Override
        public ActivityProfileState isActive(AlignmentContext locusPileup, ReferenceContext referenceContext, FeatureContext featureContext) {
            return new ActivityProfileState(new SimpleInterval(locusPileup), 1.0);
        }
    }
}

