/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.PrintStream;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.ExampleProgramGroup;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.LocusWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;

@CommandLineProgramProperties(summary="Example tool that prints locus-based coverage from supplied read to the specified output file (stdout if none provided), along with overlapping reference bases/features (if provided)", oneLineSummary="Example tool that prints locus-based coverage with optional contextual data", programGroup=ExampleProgramGroup.class, omitFromCommandLine=true)
public class ExampleLocusWalker
extends LocusWalker {
    @Argument(fullName="output", shortName="O", doc="Output file (if not provided, defaults to STDOUT)", common=false, optional=true)
    private GATKPath OUTPUT_FILE = null;
    @Argument(fullName="variant", shortName="V", doc="One or more VCF files", optional=true)
    private List<FeatureInput<VariantContext>> variants;
    private PrintStream outputStream = null;

    @Override
    public void onTraversalStart() {
        this.outputStream = this.OUTPUT_FILE != null ? new PrintStream(this.OUTPUT_FILE.getOutputStream()) : System.out;
    }

    @Override
    public void apply(AlignmentContext alignmentContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        List vars;
        ReadPileup pileup = alignmentContext.getBasePileup();
        this.outputStream.printf("Current locus %s:%d (coverage=%s)\n", alignmentContext.getContig(), alignmentContext.getPosition(), pileup.size());
        if (referenceContext.hasBackingDataSource()) {
            this.outputStream.println("\tReference base(s): " + new String(referenceContext.getBases()));
        }
        if (featureContext.hasBackingDataSource() && !(vars = featureContext.getValues(this.variants)).isEmpty()) {
            this.outputStream.println("\tOverlapping variant(s):");
            for (VariantContext variant : vars) {
                this.outputStream.printf("\t\t%s:%d-%d, Ref:%s, Alt(s):%s\n", variant.getContig(), variant.getStart(), variant.getEnd(), variant.getReference(), variant.getAlternateAlleles());
            }
        }
        this.outputStream.println();
    }

    @Override
    public void closeTool() {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

