/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.ExampleProgramGroup;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.spark.LocusWalkerContext;
import org.broadinstitute.hellbender.engine.spark.LocusWalkerSpark;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;

@CommandLineProgramProperties(summary="Example tool that prints locus-based coverage from supplied read to the specified output file (stdout if none provided), along with overlapping reference bases/features (if provided)", oneLineSummary="Example tool that prints locus-based coverage with optional contextual data", programGroup=ExampleProgramGroup.class, omitFromCommandLine=true)
public final class ExampleLocusWalkerSpark
extends LocusWalkerSpark {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="output", shortName="O", doc="Output file (if not provided, defaults to STDOUT)", common=false, optional=true)
    private String outputFile = null;
    @Argument(fullName="variant", shortName="V", doc="One or more VCF files", optional=true)
    private List<FeatureInput<VariantContext>> variants;
    private PrintStream outputStream = null;

    @Override
    protected void processAlignments(JavaRDD<LocusWalkerContext> rdd, JavaSparkContext ctx) {
        rdd.map(ExampleLocusWalkerSpark.intervalFunction(this.variants)).saveAsTextFile(this.outputFile);
    }

    private static Function<LocusWalkerContext, String> intervalFunction(List<FeatureInput<VariantContext>> variants) {
        return (Function & Serializable)context -> {
            List vars;
            AlignmentContext alignmentContext = context.getAlignmentContext();
            ReferenceContext referenceContext = context.getReferenceContext();
            FeatureContext featureContext = context.getFeatureContext();
            StringBuilder sb = new StringBuilder();
            ReadPileup pileup = alignmentContext.getBasePileup();
            sb.append(String.format("Current locus %s:%d (coverage=%s)\n", alignmentContext.getContig(), alignmentContext.getPosition(), pileup.size()));
            if (referenceContext.hasBackingDataSource()) {
                sb.append("\tReference base(s): " + new String(referenceContext.getBases()));
                sb.append("\n");
            }
            if (featureContext.hasBackingDataSource() && !(vars = featureContext.getValues(variants)).isEmpty()) {
                sb.append("\tOverlapping variant(s):\n");
                for (VariantContext variant : vars) {
                    sb.append(String.format("\t\t%s:%d-%d, Ref:%s, Alt(s):%s\n", variant.getContig(), variant.getStart(), variant.getEnd(), variant.getReference(), variant.getAlternateAlleles()));
                }
            }
            return sb.toString();
        };
    }
}

