/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Arrays;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.ExampleProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.io.Resource;
import org.broadinstitute.hellbender.utils.python.PythonScriptExecutor;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@CommandLineProgramProperties(summary="Example/toy program that uses a Python script.", oneLineSummary="Example/toy program that uses a Python script.", programGroup=ExampleProgramGroup.class, omitFromCommandLine=true)
public class ExamplePostTraversalPythonExecutor
extends ReadWalker {
    @Argument(fullName="output", shortName="O", doc="Output file")
    private File javaOutputFile;
    @Argument(fullName="pythonOutputFile", shortName="P", doc="Output file for output of python process")
    private File pythonOutputFile;
    final PythonScriptExecutor pythonExecutor = new PythonScriptExecutor(true);
    private PrintStream outputStream = null;

    @Override
    public void onTraversalStart() {
        try {
            this.outputStream = this.javaOutputFile != null ? new PrintStream(this.javaOutputFile) : System.out;
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotCreateOutputFile(this.javaOutputFile.getAbsolutePath(), (Exception)e);
        }
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.outputStream.printf("Read at %s:%d-%d:\n%s\n", read.getContig(), read.getStart(), read.getEnd(), read.getBasesString());
        if (referenceContext.hasBackingDataSource()) {
            this.outputStream.println("Reference Context:\n" + new String(referenceContext.getBases()));
        }
        this.outputStream.println();
    }

    @Override
    public Object onTraversalSuccess() {
        this.outputStream.close();
        this.outputStream = null;
        Resource pythonScriptResource = new Resource("copyInputFileToOutputFile.py", ExamplePostTraversalPythonExecutor.class);
        boolean pythonReturnCode = this.pythonExecutor.executeScript(pythonScriptResource, null, Arrays.asList(this.javaOutputFile.getAbsolutePath(), this.pythonOutputFile.getAbsolutePath()));
        return pythonReturnCode;
    }

    @Override
    public void closeTool() {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

