/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples;

import java.io.PrintStream;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.ExampleProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@CommandLineProgramProperties(summary="Prints reads from the provided file(s) with corresponding reference bases (if a reference is provided) to the specified output file (or STDOUT if none specified)", oneLineSummary="Print reads with reference context", programGroup=ExampleProgramGroup.class, omitFromCommandLine=true)
public final class ExampleReadWalkerWithReference
extends ReadWalker {
    @Argument(fullName="output", shortName="O", doc="Output file (if not provided, defaults to STDOUT)", common=false, optional=true)
    private GATKPath OUTPUT_FILE = null;
    private PrintStream outputStream = null;

    @Override
    public void onTraversalStart() {
        this.outputStream = this.OUTPUT_FILE != null ? new PrintStream(this.OUTPUT_FILE.getOutputStream()) : System.out;
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.outputStream.printf("Read at %s:%d-%d:\n%s\n", read.getContig(), read.getStart(), read.getEnd(), read.getBasesString());
        if (referenceContext.hasBackingDataSource()) {
            this.outputStream.println("Reference Context:\n" + new String(referenceContext.getBases()));
        }
        this.outputStream.println();
    }

    @Override
    public void closeTool() {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

