/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.PrintStream;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.ExampleProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@CommandLineProgramProperties(summary="Prints reads from the provided file(s) along with overlapping variants (if a source of variants is provided) to the specified output file (or STDOUT if none specified)", oneLineSummary="Print reads with overlapping variants", programGroup=ExampleProgramGroup.class, omitFromCommandLine=true)
public final class ExampleReadWalkerWithVariants
extends ReadWalker {
    @Argument(fullName="variant", shortName="V", doc="One or more VCF files", optional=true)
    private List<FeatureInput<VariantContext>> variants;
    @Argument(fullName="output", shortName="O", doc="Output file (if not provided, defaults to STDOUT)", common=false, optional=true)
    private GATKPath outputFile;
    @Argument(fullName="groupVariantsBySource", shortName="groupVariantsBySource", doc="If true, group overlapping variants by their source when outputting them", optional=true)
    private boolean groupVariantsBySource = false;
    private PrintStream outputStream = null;

    @Override
    public void onTraversalStart() {
        this.outputStream = this.outputFile != null ? new PrintStream(this.outputFile.getOutputStream()) : System.out;
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.outputStream.printf("Read at %s:%d-%d:\n%s\n", read.getContig(), read.getStart(), read.getEnd(), read.getBasesString());
        if (this.groupVariantsBySource) {
            for (FeatureInput<VariantContext> featureSource : this.variants) {
                this.outputStream.println("From source " + featureSource.getName());
                for (VariantContext variant : featureContext.getValues(featureSource)) {
                    this.outputStream.printf("\t", new Object[0]);
                    this.printOverlappingVariant(variant);
                }
            }
        } else {
            for (VariantContext variant : featureContext.getValues(this.variants)) {
                this.printOverlappingVariant(variant);
            }
        }
        this.outputStream.println();
    }

    private void printOverlappingVariant(VariantContext variant) {
        this.outputStream.printf("Overlapping variant at %s:%d-%d: Ref: %s Alt(s): %s\n", variant.getContig(), variant.getStart(), variant.getEnd(), variant.getReference(), variant.getAlternateAlleles());
    }

    @Override
    public void closeTool() {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

