/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.ExampleProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.spark.ReadWalkerContext;
import org.broadinstitute.hellbender.engine.spark.ReadWalkerSpark;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@CommandLineProgramProperties(summary="Prints reads from the provided file(s) along with overlapping variants (if a source of variants is provided) to the specified output file (or STDOUT if none specified)", oneLineSummary="Print reads with overlapping variants", programGroup=ExampleProgramGroup.class, omitFromCommandLine=true)
public final class ExampleReadWalkerWithVariantsSpark
extends ReadWalkerSpark {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="variant", shortName="V", doc="One or more VCF files", optional=true)
    private List<FeatureInput<VariantContext>> variants;
    @Argument(fullName="output", shortName="O", doc="Output file (if not provided, defaults to STDOUT)", common=false, optional=true)
    private String outputFile = null;
    @Argument(fullName="groupVariantsBySource", doc="If true, group overlapping variants by their source when outputting them", optional=true)
    private boolean groupVariantsBySource = false;

    @Override
    protected void processReads(JavaRDD<ReadWalkerContext> rdd, JavaSparkContext ctx) {
        rdd.map(ExampleReadWalkerWithVariantsSpark.readFunction(this.variants, this.groupVariantsBySource)).saveAsTextFile(this.outputFile);
    }

    private static Function<ReadWalkerContext, String> readFunction(List<FeatureInput<VariantContext>> variants, boolean groupVariantsBySource) {
        return (Function & Serializable)context -> {
            GATKRead read = context.getRead();
            ReferenceContext referenceContext = context.getReferenceContext();
            FeatureContext featureContext = context.getFeatureContext();
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Read at %s:%d-%d:\n%s\n", read.getContig(), read.getStart(), read.getEnd(), read.getBasesString()));
            if (groupVariantsBySource) {
                for (FeatureInput featureSource : variants) {
                    sb.append("From source " + featureSource.getName());
                    sb.append("\n");
                    for (VariantContext variant : featureContext.getValues(featureSource)) {
                        sb.append(String.format("\t", new Object[0]));
                        ExampleReadWalkerWithVariantsSpark.printOverlappingVariant(sb, variant);
                    }
                }
            } else {
                for (VariantContext variant : featureContext.getValues(variants)) {
                    ExampleReadWalkerWithVariantsSpark.printOverlappingVariant(sb, variant);
                }
            }
            sb.append("\n");
            return sb.toString();
        };
    }

    private static void printOverlappingVariant(StringBuilder sb, VariantContext variant) {
        sb.append(String.format("Overlapping variant at %s:%d-%d: Ref: %s Alt(s): %s\n", variant.getContig(), variant.getStart(), variant.getEnd(), variant.getReference(), variant.getAlternateAlleles()));
    }
}

