/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.ExampleProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceWalker;
import org.broadinstitute.hellbender.utils.SimpleInterval;

@CommandLineProgramProperties(summary="Example of how to implement a ReferenceWalker that uses reads and features as well as a custom window", oneLineSummary="Example of how to implement a ReferenceWalker", programGroup=ExampleProgramGroup.class, omitFromCommandLine=true)
public class ExampleReferenceWalker
extends ReferenceWalker {
    @Argument(fullName="variant", shortName="V", doc="variants to count overlaps of")
    private FeatureInput<VariantContext> variants;
    @VisibleForTesting
    final Map<String, OverlapCounts> contextCounts = new HashMap<String, OverlapCounts>();

    @Override
    protected SimpleInterval getReferenceWindow(SimpleInterval locus) {
        return new SimpleInterval(locus.getContig(), Math.max(locus.getStart() - 1, 1), locus.getStart() + 1);
    }

    @Override
    public void apply(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext) {
        byte[] bases = referenceContext.getBases();
        String baseString = new String(bases);
        OverlapCounts counts = this.contextCounts.getOrDefault(baseString, new OverlapCounts());
        if (readsContext.iterator().hasNext()) {
            ++counts.overlappedByReads;
        }
        if (!featureContext.getValues(this.variants).isEmpty()) {
            ++counts.overlappedByVariants;
        }
        ++counts.timesSeen;
        this.contextCounts.put(baseString, counts);
    }

    @Override
    public Object onTraversalSuccess() {
        this.contextCounts.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEachOrdered(entry -> System.out.println((String)entry.getKey() + " " + ((OverlapCounts)entry.getValue()).toString()));
        return 0;
    }

    @VisibleForTesting
    static class OverlapCounts {
        long timesSeen = 0L;
        long overlappedByReads = 0L;
        long overlappedByVariants = 0L;

        OverlapCounts() {
        }

        public String toString() {
            return String.format("Seen: %d Reads %d Variants %d", this.timesSeen, this.overlappedByReads, this.overlappedByVariants);
        }
    }
}

