/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.ExampleProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.utils.python.StreamingPythonScriptExecutor;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.runtime.AsynchronousStreamWriter;

@CommandLineProgramProperties(summary="Example/toy program that uses a Python script.", oneLineSummary="Example/toy program that uses a Python script.", programGroup=ExampleProgramGroup.class, omitFromCommandLine=true)
public class ExampleStreamingPythonExecutor
extends ReadWalker {
    private static final String NL = System.lineSeparator();
    @Argument(fullName="output", shortName="O", doc="Output file")
    private File outputFile;
    @Argument(fullName="batchSize", doc="Size of a batch for writing")
    private int batchSize = 1000;
    final StreamingPythonScriptExecutor<String> pythonExecutor = new StreamingPythonScriptExecutor(true);
    private List<String> batchList = new ArrayList<String>(this.batchSize);
    private int batchCount = 0;

    @Override
    public void onTraversalStart() {
        this.pythonExecutor.start(Collections.emptyList());
        this.pythonExecutor.initStreamWriter(AsynchronousStreamWriter.stringSerializer);
        this.pythonExecutor.sendSynchronousCommand(String.format("tempFile = open('%s', 'w')" + NL, this.outputFile.getAbsolutePath()));
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        if (this.batchCount == this.batchSize) {
            this.pythonExecutor.waitForPreviousBatchCompletion();
            this.startAsynchronousBatchWrite();
        }
        this.batchList.add(String.format("Read at %s:%d-%d:\n%s\n", read.getContig(), read.getStart(), read.getEnd(), read.getBasesString()));
        ++this.batchCount;
    }

    @Override
    public Object onTraversalSuccess() {
        this.pythonExecutor.waitForPreviousBatchCompletion();
        if (this.batchCount != 0) {
            this.startAsynchronousBatchWrite();
            this.pythonExecutor.waitForPreviousBatchCompletion();
        }
        return true;
    }

    private void startAsynchronousBatchWrite() {
        this.pythonExecutor.startBatchWrite(String.format("for i in range(%s):\n    tempFile.write(tool.readDataFIFO())" + NL + NL, this.batchCount), this.batchList);
        this.batchList = new ArrayList<String>(this.batchSize);
        this.batchCount = 0;
    }

    @Override
    public void closeTool() {
        this.pythonExecutor.sendSynchronousCommand("tempFile.close()" + NL);
        this.pythonExecutor.terminate();
    }
}

