/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.ExampleProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.TwoPassVariantWalker;

@CommandLineProgramProperties(summary="Example variant walker that makes two passes through a vcf", oneLineSummary="Example two-pass variant walker", programGroup=ExampleProgramGroup.class, omitFromCommandLine=true)
public class ExampleTwoPassVariantWalker
extends TwoPassVariantWalker {
    @Argument(fullName="output", shortName="O", doc="Output vcf", optional=true)
    private GATKPath outputVcf = null;
    private final List<Double> qualByDepths = new ArrayList<Double>();
    private VariantContextWriter vcfWriter;
    public static final String QD_DISTANCE_FROM_MEAN = "QD_DIST";
    public static final String COPY_OF_QD_KEY_NAME = "QD_COPY";
    private double averageQualByDepth;
    private double sampleVarianceOfQDs;
    private int counter = 0;

    @Override
    public void onTraversalStart() {
        VCFHeader inputHeader = this.getHeaderForVariants();
        inputHeader.addMetaDataLine((VCFHeaderLine)new VCFInfoHeaderLine(QD_DISTANCE_FROM_MEAN, 1, VCFHeaderLineType.Float, "distance from the average QD value in the units of standard deviations"));
        inputHeader.addMetaDataLine((VCFHeaderLine)new VCFInfoHeaderLine(COPY_OF_QD_KEY_NAME, 1, VCFHeaderLineType.Float, "copy of the QD INFO field"));
        this.vcfWriter = this.createVCFWriter(this.outputVcf);
        this.vcfWriter.writeHeader(inputHeader);
    }

    @Override
    protected void firstPassApply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.qualByDepths.add(variant.getAttributeAsDouble("QD", 0.0));
    }

    @Override
    protected void afterFirstPass() {
        int n = this.qualByDepths.size();
        if (n == 1) {
            return;
        }
        this.averageQualByDepth = this.qualByDepths.stream().mapToDouble(x -> x).average().orElse(0.0);
        this.sampleVarianceOfQDs = 1.0 / ((double)n - 1.0) * this.qualByDepths.stream().mapToDouble(x -> Math.pow(x - this.averageQualByDepth, 2.0)).sum();
    }

    @Override
    protected void secondPassApply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        VariantContextBuilder vcb = new VariantContextBuilder(variant);
        double qualByDepth = this.qualByDepths.get(this.counter++);
        double distanceFromMean = Math.abs((qualByDepth - this.averageQualByDepth) / Math.sqrt(this.sampleVarianceOfQDs));
        vcb.attribute(QD_DISTANCE_FROM_MEAN, (Object)distanceFromMean);
        vcb.attribute(COPY_OF_QD_KEY_NAME, (Object)qualByDepth);
        this.vcfWriter.add(vcb.make());
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }
}

