/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.PrintStream;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.ExampleProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@CommandLineProgramProperties(summary="Example tool that prints variants supplied to the specified output file (stdout if none provided), along with overlapping reads/reference bases/variants (if provided)", oneLineSummary="Example tool that prints variants with optional contextual data", programGroup=ExampleProgramGroup.class, omitFromCommandLine=true)
public final class ExampleVariantWalker
extends VariantWalker {
    @Argument(fullName="output", shortName="O", doc="Output file (if not provided, defaults to STDOUT)", common=false, optional=true)
    private GATKPath outputFile = null;
    @Argument(fullName="auxiliaryVariants", shortName="av", doc="Auxiliary set of variants", optional=true)
    private FeatureInput<VariantContext> auxiliaryVariants;
    private PrintStream outputStream = null;

    @Override
    public void onTraversalStart() {
        this.outputStream = this.outputFile != null ? new PrintStream(this.outputFile.getOutputStream()) : System.out;
    }

    @Override
    public void apply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.outputStream.println("Current variant: " + variant);
        if (referenceContext.hasBackingDataSource()) {
            this.printReferenceBases(referenceContext);
        }
        if (readsContext.hasBackingDataSource()) {
            this.printReads(readsContext);
        }
        if (featureContext.hasBackingDataSource()) {
            this.printVariants(featureContext);
        }
    }

    private void printReferenceBases(ReferenceContext refContext) {
        this.outputStream.printf("\tOverlapping reference bases: %s\n\n", new String(refContext.getBases()));
    }

    private void printReads(ReadsContext readsContext) {
        for (GATKRead read : readsContext) {
            this.outputStream.printf("\tOverlapping read at %s:%d-%d\n", read.getContig(), read.getStart(), read.getEnd());
        }
        this.outputStream.println();
    }

    private void printVariants(FeatureContext featureContext) {
        for (VariantContext variant : featureContext.getValues(this.auxiliaryVariants)) {
            this.outputStream.printf("\tOverlapping variant at %s:%d-%d. Ref: %s Alt(s): %s\n", variant.getContig(), variant.getStart(), variant.getEnd(), variant.getReference(), variant.getAlternateAlleles());
        }
        this.outputStream.println();
    }

    @Override
    public void closeTool() {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

